(* Copyright (C) 1990, Digital Equipment Corporation.         *)
(* All rights reserved.                                       *)
(* See the file COPYRIGHT for a full description.             *)

(* Last modified on Thu Sep 19 18:24:16 1991 by kalsow        *)
(*      modified on Tue Jun 11 20:27:00 1991 by muller        *)
(*      modified on Thu Feb  8 17:51:32 1990 by mcjones       *)

MODULE STextTable EXPORTS STextTable, STextTableF;

IMPORT List, STable, STableF, Text;

REVEAL T = BRANDED REF STable.T;

PROCEDURE Compare (<*UNUSED*> arg: REFANY; key1, key2: STable.Key): INTEGER =
  BEGIN
    IF key1 = NIL THEN key1 := ""; END;
    IF key2 = NIL THEN key2 := ""; END;
    RETURN Text.Compare (key1, key2)
  END Compare;

PROCEDURE New (): T RAISES {} =
  VAR
    t:= NEW (T);
  BEGIN
    t^ := STable.New (Compare, NIL);
    RETURN t
  END New;

PROCEDURE Get (table: T; key: Key; VAR value: Value): BOOLEAN RAISES {} =
  BEGIN
    RETURN STable.Get (table^, key, value)
  END Get;

PROCEDURE Put (table: T; key: Key; value: Value): BOOLEAN RAISES {} =
  BEGIN
    RETURN STable.Put (table^, key, value)
  END Put;

PROCEDURE Delete (table: T; key: Key; VAR value: Value): BOOLEAN RAISES {} =
  BEGIN
    RETURN STable.Delete (table^, key, value)
  END Delete;

PROCEDURE Clear (table: T) RAISES {} =
  BEGIN
    STable.Clear (table^)
  END Clear;

PROCEDURE Copy (table: T): T RAISES {} =
  VAR
    t := NEW (T);
  BEGIN
    t^ := STable.Copy (table^);
    RETURN t
  END Copy;

REVEAL Stream = BRANDED REF STable.Stream;

PROCEDURE NewStream
  (table: T; ascending: BOOLEAN := TRUE; key0: Key := NIL): Stream RAISES {} =
   VAR
     s:= NEW (Stream);
  BEGIN
    s := NEW (Stream);
    s^ :=  STable.NewStream (table^, ascending, key0);
    RETURN s
  END NewStream;

PROCEDURE Next
  (s: Stream; VAR key: Key; VAR value: Value): BOOLEAN RAISES {} =
  VAR success: BOOLEAN; k: STable.Key;
  BEGIN
    success := STable.Next (s^, k, value);
    IF success THEN key := k END;
    RETURN success
  END Next;

PROCEDURE FindFirst
  (table: T; pred: Predicate; arg: REFANY; VAR key: Key; VAR value: Value;
   ascending := TRUE; key0: Key := NIL)
   : BOOLEAN (* RAISES {raises( proc )} *) =
  VAR
    k: STable.Key;
    v: STable.Value; (* = REFANY = Value *)
    s: STable.Stream;
  BEGIN
    s := STable.NewStream (table^, ascending, key0);
    LOOP
      IF  NOT STable.Next (s, k, v) THEN RETURN FALSE END;
      IF pred (arg, k, v) THEN
        key := k;
        value := v;
        RETURN TRUE
      END
    END
  END FindFirst;

PROCEDURE ToValuesList (table: T; ascending := TRUE): List.T RAISES {} =
  BEGIN
    RETURN STable.ToValuesList (table^, ascending)
  END ToValuesList;

PROCEDURE ToAssocList (table: T; ascending := TRUE): List.T RAISES {} =
  BEGIN
    RETURN STable.ToAssocList (table^, ascending)
  END ToAssocList;

PROCEDURE Validate (table: T) RAISES {} =
  BEGIN
    STableF.Validate (table^)
  END Validate;

BEGIN
END STextTable.
