(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Thu Jun 25 18:21:12 PDT 1992 by muller     *)
(*      modified on Tue Feb 25 10:34:07 PST 1992 by kalsow     *)

UNSAFE INTERFACE RTStack;

TYPE
  T = UNTRACED REF ARRAY OF INTEGER;
  (* a thread stack *)

CONST
  PointerAlignment = 4;
  (* The C compiler allocates all pointers on 'PointerAlignment'-byte
     boundaries.  The garbage collector scans thread stacks, but only
     looks at these possible pointer locations.  Setting this value
     smaller than is needed will only make your system run slower.
     Setting it too large will cause the collector to collect storage
     that is not free. *)

  StackFrameAlignment = 8;
  (* Stack frames must be aligned to this constraint (in ADRSIZE units). 
     It's not a big deal if this value is too large, but it may break 
     the thread mechanism to make it too small. *)

PROCEDURE New (size: INTEGER): T;
(* Allocate a thread stack with at least 'size' usable INTEGERs of storage,
   unmap its guard page, and return it. *)

PROCEDURE Dispose (t: T);
(* Dispose of 't' and remap its guard page. *)

PROCEDURE GetBounds (t: T;  VAR(*OUT*) first, last: ADDRESS);
(* returns the range of usable addresses in stack 't': [first .. last) *)

END RTStack.

