(* Copyright (C) 1990, 1992, Digital Equipment Corporation                   *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last modified on Tue Mar 24 16:55:53 PST 1992 by muller                   *)
(*      modified on Fri Feb 28 12:06:06 PST 1992 by kalsow                   *)

UNSAFE MODULE RTStack;

PROCEDURE New (size: INTEGER): T =
  BEGIN
    RETURN NEW (T, size);
  END New;

PROCEDURE Dispose (t: T) =
  BEGIN
    DISPOSE (t);
  END Dispose;

PROCEDURE GetBounds (t: T;  VAR(*OUT*) first, last: ADDRESS) =
  BEGIN
    first := ADR (t[0]);
    last  := ADR (t[0]) + NUMBER (t^) * ADRSIZE (t[0]);
  END GetBounds;

BEGIN
END RTStack.

