(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Wed Oct 28 15:39:31 MET 1992 by preschern  *)


MODULE FPU;

IMPORT Ctypes, Word;

(* This interface defines the DS3100 hardware (and libm.a) defined interface
   to floating-point values *)

PROCEDURE LongClass (x: LONGREAL): Ctypes.int =
  BEGIN
    <* ASSERT FALSE *>
  END LongClass;

PROCEDURE RealClass (x: REAL): Ctypes.int =
(* returns the IEEE defined class of its argument *)
  BEGIN
    <* ASSERT FALSE *>
  END RealClass;

(*----------------------------------------------- control/status register ---*)

PROCEDURE GetStatus (): INTEGER(*ControlStatus*) =
(* returns the current setting of the floating point control registers *)
  BEGIN
    <* ASSERT FALSE *>
  END GetStatus;

PROCEDURE SetStatus (new: INTEGER): INTEGER(*ControlStatus*) =
(* sets the floating point control registers and returns their previous state*)
  BEGIN
    (* let it run - should be <* ASSERT FALSE *> but if so it breaks in 
     * FloatMode.InitThread which is in turn called by Thread.Main 
     *)
    RETURN 0;
  END SetStatus;

PROCEDURE SetRounding(new: INTEGER):INTEGER(*RoundingMode*) =
(* sets the rounding mode and returns its previous value *)
  BEGIN
    <* ASSERT FALSE *>
  END SetRounding;

PROCEDURE SetInexact (new: INTEGER): INTEGER(*BOOLEAN*) =
(* sets the "sticky inexact bit" and returns its old value *)
  BEGIN
    <* ASSERT FALSE *>
  END SetInexact;

(*--------------------------------------------- standard? IEEE operations ---*)

PROCEDURE IsNaN (x: LONGREAL): INTEGER (*BOOLEAN*) =
(* return 1 if x is NaN, 0 otherwise. *)
  BEGIN
    <* ASSERT FALSE *>
  END IsNaN;

PROCEDURE CopySign (x, y: LONGREAL): LONGREAL =
(* return 'x' with the sign of 'y'. *)
  BEGIN
    <* ASSERT FALSE *>
  END CopySign;

PROCEDURE Remainder (x, y: LONGREAL): LONGREAL =
(* returns the remainder r := x - n*y  where n is the integer nearest the
   exact value of x/y.  Additionally if |n-x/y|=1/2, then n is even.
   Consequently the remainder is computed exactly and |r| < |y|/2.
   Remainder (x, 0.0) and Remainder (infinity, y) produce NaN. *)
  BEGIN
    <* ASSERT FALSE *>
  END Remainder;

PROCEDURE IsFinite (x: LONGREAL): INTEGER (*BOOLEAN*) =
(* = 1 if -infinity < x < +infinity, otherwise = 0 *)
  BEGIN
    <* ASSERT FALSE *>
  END IsFinite;

PROCEDURE BinaryLog (x: LONGREAL): LONGREAL =
(* for x finite, non-zero, and above the underflow threshold,
   returns the integer valued floating-point number n, such that
   1 < ABS (x) / (2^n) < 2.  Note that BinaryLog (+infinity) = +infinity,
   and BinaryLog (0) = -infinity (and causes a division-by-zero error). *)
  BEGIN
    <* ASSERT FALSE *>
  END BinaryLog;

PROCEDURE BinaryPower (x: LONGREAL;  n: INTEGER): LONGREAL =
(* returns x * (2^n) *)
  BEGIN
    <* ASSERT FALSE *>
  END BinaryPower;

BEGIN
END FPU.
