(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Feb 28 21:39:17 PST 1992 by stolfi     *)
(*      modified on Thu Feb 20 15:55:21 PST 1992 by muller     *)
(*      modified on Wed Sep 25 00:48:06 1991 by kalsow         *)

UNSAFE MODULE ExtendedFloat;

IMPORT Math, FPU;

PROCEDURE Scalb(x: T; n: INTEGER): T =
  BEGIN
    RETURN FLOAT (FPU.BinaryPower (FLOAT (x, LONGREAL), n), T);
  END Scalb;

PROCEDURE Logb(x: T): T =
  BEGIN
    RETURN FLOAT (FPU.BinaryLog (FLOAT (x, LONGREAL)), T);
  END Logb;

PROCEDURE ILogb(x: T): INTEGER =
  BEGIN
    RETURN TRUNC (FPU.BinaryLog (FLOAT (x, LONGREAL)));
  END ILogb;

PROCEDURE NextAfter(<*UNUSED*> x, y: T): T =
  BEGIN
    <* ASSERT FALSE *>
  END NextAfter;

PROCEDURE CopySign(x, y: T): T =
  BEGIN
    RETURN FLOAT (FPU.CopySign (FLOAT (x,LONGREAL), FLOAT (y,LONGREAL)), T);
  END CopySign;

PROCEDURE Finite(x: T): BOOLEAN =
  BEGIN
    RETURN FPU.IsFinite (FLOAT (x, LONGREAL)) # 0;
  END Finite;

PROCEDURE IsNaN(x: T): BOOLEAN =
  BEGIN
    RETURN FPU.IsNaN (FLOAT (x, LONGREAL)) # 0;
  END IsNaN;

PROCEDURE Sign(x: T): [0..1] =
  VAR xx := LOOPHOLE (x, FPU.ExtendedRep);
  BEGIN
    RETURN xx.sign;
  END Sign;

PROCEDURE Differs(x, y: T): BOOLEAN =
  BEGIN
    RETURN (x < y) OR (y < x);
  END Differs;

PROCEDURE Unordered(x, y: T): BOOLEAN =
  BEGIN
    RETURN NOT (x <= y OR y <= x);
  END Unordered;

PROCEDURE Sqrt(x: T): T =
  BEGIN
    RETURN FLOAT (Math.sqrt (FLOAT (x, LONGREAL)), T);
  END Sqrt;
  
PROCEDURE Class(x: T): IEEEClass =
  CONST
    Map = ARRAY [0..9] OF IEEEClass {
      IEEEClass.SignalingNaN (* FPU.FPClass.SignalingNaN *),
      IEEEClass.QuietNaN     (* FPU.FPClass.QuietNaN *),
      IEEEClass.Infinity     (* FPU.FPClass.PosInfinity *),
      IEEEClass.Infinity     (* FPU.FPClass.NegInfinity *),
      IEEEClass.Normal       (* FPU.FPClass.PosNormal *),
      IEEEClass.Normal       (* FPU.FPClass.NegNormal *),
      IEEEClass.Denormal     (* FPU.FPClass.PosDenormal *),
      IEEEClass.Denormal     (* FPU.FPClass.NegDenormal *),
      IEEEClass.Zero         (* FPU.FPClass.PosZero *),
      IEEEClass.Zero         (* FPU.FPClass.NegZero *)
    };
  BEGIN
    RETURN Map [FPU.LongClass (FLOAT (x, LONGREAL))];
  END Class;

BEGIN       
END ExtendedFloat.
