(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Feb 14 08:29:15 PST 1992 by kalsow     *)
(*      modified on Wed Mar 13 01:14:25 1991 by muller         *)
(*      modified on Tue Apr 24 16:40:16 1990 by jerome         *)

UNSAFE MODULE M3toC;

IMPORT Ctypes, Cstdlib, Cstring, TextF, RT0, RTArgs;

VAR zeroValue := 0;

TYPE
  M3TextBody = RECORD
                 string: ADDRESS;
                 size:   INTEGER END;

  M3Text = UNTRACED REF M3TextBody;

  M3TextWithHeader = UNTRACED REF RECORD
                       header: RT0.RefHeader;
                       body: M3TextBody; END;

PROCEDURE TtoS (t: TEXT): Ctypes.CharStar =
  BEGIN
    IF t = NIL OR t = "" THEN
      RETURN ADR (zeroValue)
    ELSE
      (* the magic to indirect on an open array *)
      RETURN LOOPHOLE (t, M3Text).string;
    END;
  END TtoS;

PROCEDURE CopyTtoS (t: TEXT): Ctypes.CharStar =
  BEGIN
    IF t = NIL OR t = "" THEN
      RETURN ADR (zeroValue);
    ELSE
      RETURN Cstring.memcpy (Cstdlib.malloc (NUMBER (t^)), ADR (t[0]), NUMBER (t^));
    END;
  END CopyTtoS;

PROCEDURE FreeS (<*UNUSED*> s: Ctypes.CharStar) =
  BEGIN
  END FreeS;


PROCEDURE StoT (s: Ctypes.CharStar): TEXT =
  BEGIN
    WITH t = NEW (M3TextWithHeader,
                    header := RT0.RefHeader {forwarded := FALSE,
                                             typecode  := RT0.TextTypecode},
                    body   := M3TextBody {string := s,
                                          size   := 1 + Cstring.strlen (s)}) DO
      RETURN LOOPHOLE (ADR (t.body), TEXT); END;
  END StoT;

PROCEDURE CopyStoT (s: Ctypes.CharStar): TEXT =
  BEGIN
    WITH l = Cstring.strlen (s) + 1,
         t = NEW (TEXT, l) DO
      EVAL Cstring.memcpy (ADR (t[0]), s, l);
      RETURN t; END;
  END CopyStoT;


PROCEDURE ItoP (t: INTEGER): ADDRESS =
  BEGIN
       RETURN (LOOPHOLE (t, ADDRESS));
  END ItoP;

PROCEDURE RtoP (t: REAL): ADDRESS =
  BEGIN
       RETURN (LOOPHOLE (t, ADDRESS));
  END RtoP;

PROCEDURE UtoP (t: Ctypes.UnsignedLong): ADDRESS =
  BEGIN
       RETURN (LOOPHOLE (t, ADDRESS));
  END UtoP;

PROCEDURE PtoI (t: ADDRESS): INTEGER =
  BEGIN
       RETURN (LOOPHOLE (t, INTEGER));
  END PtoI;

PROCEDURE PtoR (t: ADDRESS): REAL =
  BEGIN
       RETURN (LOOPHOLE (t, REAL));
  END PtoR;

PROCEDURE PtoFS (t: ADDRESS): Ctypes.FloatStar =
  BEGIN
       RETURN (LOOPHOLE (t, Ctypes.FloatStar));
  END PtoFS;

PROCEDURE PtoDS (t: ADDRESS): Ctypes.DoubleStar =
  BEGIN
       RETURN (LOOPHOLE (t, Ctypes.DoubleStar));
  END PtoDS;


BEGIN
  argc      := RTArgs.argc;
  adr_argc  := ADR (RTArgs.argc);
  argv      := LOOPHOLE (RTArgs.argv, Argv);

  null      := TtoS("");
  nullString := ADR (zeroValue);
END M3toC.
