(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Variable.i3                                           *)
(* Last Modified On Mon Jun 29 16:12:53 PDT 1992 By kalsow     *)
(*      Modified On Fri Apr 27 03:11:00 1990 By muller         *)

INTERFACE Variable;

IMPORT String, Type, Token, Value, Temp,  Scope, Decl, Tracer;

TYPE
  T <: Value.T;

PROCEDURE ParseDecl (READONLY fail: Token.Set; att: Decl.Attributes);

PROCEDURE New (name: String.T;  used: BOOLEAN): T;
(* doesn't insert the object into any scope.... *)

PROCEDURE NewFormal (formal: Value.T;  name: String.T): T;

PROCEDURE BindType (t: T;  type: Type.T;
                    indirect, readonly, allowOpenArray: BOOLEAN:= FALSE);

PROCEDURE Split (t: T;  VAR type: Type.T;  VAR indirect, readonly: BOOLEAN);

PROCEDURE IsFormal (t: T): BOOLEAN;
PROCEDURE IsIndirect (t: T): BOOLEAN;
PROCEDURE HasClosure (t: T): BOOLEAN;

PROCEDURE SetBounds (t: T;  min, max: INTEGER);
PROCEDURE GetBounds (t: T;  VAR min, max: INTEGER);

PROCEDURE Load (t: T): Temp.T;
PROCEDURE LoadLValue (t: T);

PROCEDURE InitGlobal (t: T);

PROCEDURE GenGlobalMap (s: Scope.T): BOOLEAN;

PROCEDURE ParseTrace (READONLY fail: Token.Set): Tracer.T;
PROCEDURE BindTrace  (t: T;  x: Tracer.T);
PROCEDURE CheckTrace (x: Tracer.T;  VAR cs: Value.CheckState);
PROCEDURE ScheduleTrace (t: T);

PROCEDURE Initialize ();

END Variable.
