(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: RefType.i3                                            *)
(* Last Modified On Tue Jul  9 23:55:51 1991 By kalsow         *)

INTERFACE RefType;

IMPORT Type, Token, String, Expr;

PROCEDURE Parse (READONLY fail: Token.Set): Type.T;

PROCEDURE ParseBrand (READONLY fail: Token.Set): Expr.T;

PROCEDURE New (target: Type.T;  traced: BOOLEAN;  brand: Expr.T): Type.T;

PROCEDURE Is (t: Type.T): BOOLEAN;

PROCEDURE IsBranded (t: Type.T): BOOLEAN;

PROCEDURE Split (t: Type.T;  VAR target: Type.T): BOOLEAN;

PROCEDURE NoteBrand (t: Type.T;  b: String.T);

END RefType.
