(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Token.m3                                              *)
(* Last modified on Mon Jun 29 09:17:36 PDT 1992 by kalsow     *)
(*      modified on Sat Mar 16 00:31:12 1991 by muller         *)

MODULE Token;

IMPORT String;

PROCEDURE RW (s: TEXT;  tok: T) =
  VAR str: String.T;
  BEGIN
    str := String.Add (s);
    String.SetClass (str, ORD (tok));
    name[tok] := str;
  END RW;

PROCEDURE Initialize () =
  BEGIN
    RW ("*EOF*",         T.tEOF);
    RW ("*id*",          T.tIDENT);
    RW ("*cardinal*",    T.tCARDCONST);
    RW ("*real*",        T.tREALCONST);
    RW ("*longreal*",    T.tLONGREALCONST);
    RW ("*char*",        T.tCHARCONST);
    RW ("*text*",        T.tTEXTCONST);
    RW ("+",             T.tPLUS);
    RW ("-",             T.tMINUS);
    RW ("*",             T.tASTERISK);
    RW ("/",             T.tSLASH);
    RW (":=",            T.tASSIGN);
    RW ("&",             T.tAMPERSAND);
    RW (".",             T.tDOT);
    RW (",",             T.tCOMMA);
    RW (";",             T.tSEMI);
    RW ("(",             T.tLPAREN);
    RW ("[",             T.tLBRACKET);
    RW ("{",             T.tLBRACE);
    RW ("^",             T.tARROW);
    RW ("=",             T.tEQUAL);
    RW ("#",             T.tSHARP);
    RW ("<",             T.tLESS);
    RW (">",             T.tGREATER);
    RW ("<=",            T.tLSEQUAL);
    RW (">=",            T.tGREQUAL);
    RW ("..",            T.tDOTDOT);
    RW (":",             T.tCOLON);
    RW (")",             T.tRPAREN);
    RW ("]",             T.tRBRACKET);
    RW ("}",             T.tRBRACE);
    RW ("|",             T.tBAR);
    RW ("<:",            T.tSUBTYPE);
    RW ("=>",            T.tIMPLIES);
    RW ("*>",            T.tENDPRAGMA);
 
    RW ("INLINE",        T.tINLINE);
    RW ("EXTERNAL",      T.tEXTERNAL);
    RW ("ASSERT",        T.tASSERT);
    RW ("UNUSED",        T.tUNUSED);
    RW ("OBSOLETE",      T.tOBSOLETE);
    RW ("TRACE",         T.tTRACE);
    RW ("FATAL",         T.tFATAL);

    RW ("AND",           T.tAND);
    RW ("ANY",           T.tANY);
    RW ("ARRAY",         T.tARRAY);
    RW ("AS",            T.tAS);
    RW ("BEGIN",         T.tBEGIN);
    RW ("BITS",          T.tBITS);
    RW ("BRANDED",       T.tBRANDED);
    RW ("BY",            T.tBY);
    RW ("CASE",          T.tCASE);
    RW ("CONST",         T.tCONST);
    RW ("DIV",           T.tDIV);
    RW ("DO",            T.tDO);
    RW ("ELSE",          T.tELSE);
    RW ("ELSIF",         T.tELSIF);
    RW ("END",           T.tEND);
    RW ("EXCEPT",        T.tEXCEPT);
    RW ("EXCEPTION",     T.tEXCEPTION);
    RW ("EXIT",          T.tEXIT);
    RW ("EXPORTS",       T.tEXPORTS);
    RW ("EVAL",          T.tEVAL);
    RW ("FINALLY",       T.tFINALLY);
    RW ("FOR",           T.tFOR);
    RW ("FROM",          T.tFROM);
    RW ("GENERIC",       T.tGENERIC);
    RW ("IF",            T.tIF);
    RW ("IMPORT",        T.tIMPORT);
    RW ("IN",            T.tIN);
    RW ("INTERFACE",     T.tINTERFACE);
    RW ("LOCK",          T.tLOCK);
    RW ("LOOP",          T.tLOOP);
    RW ("METHODS",       T.tMETHODS);
    RW ("MOD",           T.tMOD);
    RW ("MODULE",        T.tMODULE);
    RW ("NOT",           T.tNOT);
    RW ("OBJECT",        T.tOBJECT);
    RW ("OF",            T.tOF);
    RW ("OR",            T.tOR);
    RW ("OVERRIDES",     T.tOVERRIDES);
    RW ("PROCEDURE",     T.tPROCEDURE);
    RW ("RAISE",         T.tRAISE);
    RW ("RAISES",        T.tRAISES);
    RW ("READONLY",      T.tREADONLY);
    RW ("RECORD",        T.tRECORD);
    RW ("REF",           T.tREF);
    RW ("REPEAT",        T.tREPEAT);
    RW ("RETURN",        T.tRETURN);
    RW ("REVEAL",        T.tREVEAL);
    RW ("SET",           T.tSET);
    RW ("THEN",          T.tTHEN);
    RW ("TO",            T.tTO);
    RW ("TRY",           T.tTRY);
    RW ("TYPE",          T.tTYPE);
    RW ("TYPECASE",      T.tTYPECASE);
    RW ("UNSAFE",        T.tUNSAFE);
    RW ("UNTIL",         T.tUNTIL);
    RW ("UNTRACED",      T.tUNTRACED);
    RW ("VALUE",         T.tVALUE);
    RW ("VAR",           T.tVAR);
    RW ("WHILE",         T.tWHILE);
    RW ("WITH",          T.tWITH);

  END Initialize;

BEGIN
END Token.
