(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Closure.m3                                            *)
(* Last Modified On Mon Mar  2 10:31:59 PST 1992 by kalsow     *)
(*      Modified On Wed Sep 26 19:20:18 1990 by muller         *)

MODULE Closure;

IMPORT Type, TypeRep, Target, Emit, MBuf, Tipe;

TYPE
  P = Type.T BRANDED "Closure.T" OBJECT
      OVERRIDES
      (*check      := ALREADY DONE *)
        base       := TypeRep.SelfBase;
        isEqual    := TypeRep.NeverEqual;
        isSubtype  := TypeRep.NoSubtypes;
        count      := TypeRep.NotOrdinal;
        bounds     := TypeRep.NotBounded;
        size       := Sizer;
        minSize    := Sizer;
        alignment  := Aligner;
	isEmpty    := TypeRep.IsNever;
        dependsOn  := TypeRep.DependsOnNone;
        compile    := Compiler;
        initCost   := InitCoster;
        initValue  := GenInit;
        mapper     := TypeRep.NoMapper;
        fprint     := FPrinter;
        class      := MyClass;
      END;

PROCEDURE MyClass (<*UNUSED*> t: Type.T): TypeRep.Class =
  BEGIN
    RETURN TypeRep.Class.None;
  END MyClass;

PROCEDURE Sizer (<*UNUSED*> t: Type.T): INTEGER =
  BEGIN
    RETURN Target.ADDRSIZE;
  END Sizer;

PROCEDURE Aligner (<*UNUSED*> t: Type.T): INTEGER =
  BEGIN
    RETURN Target.ADDRALIGN;
  END Aligner;

PROCEDURE Compiler (t: Type.T) =
  BEGIN
    Emit.OpF ("\003#define @ _CLOSURE\n", t);
    IF TypeRep.StartLinkInfo (t) THEN RETURN END;
    Emit.Op  ("C\n");
    Emit.OpF ("\003#define @ _CLOSURE\n", t);
    Emit.Op  ("*\n");
  END Compiler;

PROCEDURE InitCoster (<*UNUSED*> t: Type.T; 
                      <*UNUSED*> zeroed: BOOLEAN): INTEGER =
  BEGIN
    RETURN 0;  (* compiler initializes these objects *)
  END InitCoster;

PROCEDURE GenInit (<*UNUSED*> t: Type.T) =
  BEGIN
    <* ASSERT FALSE *>
  END GenInit;

PROCEDURE FPrinter (<*UNUSED*>t: Type.T; <*UNUSED*>map: Type.FPMap; wr: MBuf.T) =
  BEGIN
    MBuf.PutText (wr, "$closure");
  END FPrinter;

PROCEDURE Initialize () =
  BEGIN
    T := NEW (P);
    TypeRep.Init (T);
    T.checked := TRUE;
    T.hash := 4;
    Tipe.Define ("_CLOSURE_TYPE", T, FALSE);
  END Initialize;

BEGIN
END Closure.
