MODULE OList	EXPORTS OList;


IMPORT	Text;


REVEAL	T = Public BRANDED OBJECT
		root:		ElmT:= NIL;
		current:	ElmT:= NIL;
	    OVERRIDES
		put:=		Put;
		get:=		Get;
		first:= 	First;
		getnext:=	Getnext;
	    END; (*OBJECT*)

	ElmT = PublicElmT BRANDED OBJECT
		next:	ElmT:= NIL;
	    END; (*OBJECT*)



PROCEDURE Put(self: T; elm: ElmT) =

	PROCEDURE Insert (VAR root: ElmT; elm: ElmT) =
	BEGIN
	    CASE self.insertMode OF
		Mode.Alphabetic=>   	IF root = NIL THEN
					    root:= elm;
					    root.next:= NIL;
					ELSIF Text.Compare(root.name,
							   elm.name) < 0
					THEN
					    Insert(root.next, elm)
					ELSE
					    elm.next:= root;
					    root:= elm;
					END; (*IF*)
	      |	Mode.FirstIn_FirstOut=> IF root = NIL THEN
					    root:= elm;
					    root.next:= NIL;
					ELSE
					    Insert(root.next, elm);
					END; (*IF*)
	      |	Mode.FirstIn_LastOut=>  elm.next:= root;
				    	root:= elm;
	    END; (*CASE*)
	END Insert;

BEGIN
    Insert(self.root, elm);
END Put;



PROCEDURE Get(self: T; name: TEXT): ElmT =

	PROCEDURE Search (root: ElmT; name: TEXT): ElmT =
	BEGIN
	    IF root = NIL THEN
		RETURN NIL;
	    ELSIF Text.Equal(root.name, name) THEN
		RETURN root;
	    ELSE
		RETURN Search(root.next, name);
	    END; (*IF*)
	END Search;

BEGIN
    self.current:= Search(self.root, name);
    RETURN self.current;
END Get;



PROCEDURE First(self: T) =
BEGIN
    self.current:= self.root;
END First;



PROCEDURE Getnext(self: T): ElmT =	(* nchstes Element der Liste holen  *)
VAR	result:	ElmT;
BEGIN
    result:= self.current;
    IF self.current # NIL THEN
	self.current:= self.current.next;
    END; (*IF*)
    RETURN result;
END Getnext;


BEGIN
END OList.