MODULE SF;	(*SimpleFiles 14.04.94. LB*)
(* Implements the procedures for simple file I/O.
   Error handling is somewhat strange: the idea was to
   catch all exceptions and convert them into simple error messages,
   in order to protect beginners from being confronted with exceptions.*)

(* Weich: inserted FATAL-pragra to get rid of warnings *)
(* LB: modified OpenWrite 23.03.94*)

  IMPORT
    SIO, FileStream, Rd, Wr, Stdio, Text, Thread;

  <*FATAL Rd.Failure, Rd.EndOfFile, Wr.Failure, Thread.Alerted*>

  CONST
    T1   = " use another name";
    TInp = " doesn't exist," & T1 & " = " ;
    T2   = ", or \""&Overwrite&"\" to overwrite = ";
    TOut = " already exists," & T1 & T2;
 
  PROCEDURE GetFileName(prompt:= PromptStart & PromptEnd): TEXT =
  BEGIN
    SIO.PutText(prompt);
    RETURN Rd.GetLine(Stdio.stdin);
  END GetFileName;

  PROCEDURE Std(name: TEXT): BOOLEAN =
  BEGIN
    RETURN (name = NIL) OR Text.Empty(name) OR Text.Equal(name, Standard)
  END Std;

  PROCEDURE OpenRead(name: TEXT := NIL; prompt:= InPrompt): Reader =
  VAR rd: Reader := NIL;
  BEGIN
    IF name = NIL THEN name:= GetFileName(prompt) END;
    WHILE NOT Std(name) AND NOT FileExists(name) DO 
      name:= GetFileName(name & TInp); 
    END;
    IF Std(name) THEN rd:= Stdio.stdin
    ELSE
      TRY
        rd:= FileStream.OpenRead(name)
      EXCEPT ELSE
        SIO.PutText("Error at SF.OpenRead\n");
      END; (*TRY*)
    END; (*IF name*)
    RETURN rd;
  END OpenRead;

  PROCEDURE OpenWrite(name: TEXT := NIL; prompt:= OutPrompt;
                      overwrite:= FALSE): Writer =
  VAR saveName: TEXT; wr: Writer := NIL;
  BEGIN
    IF name = NIL THEN name:= GetFileName(prompt) END;
    WHILE NOT Std(name) AND NOT overwrite AND FileExists(name) DO
      saveName:= name;
      name:= GetFileName(name & TOut);
      IF NOT Std(name) AND Text.Equal(name, Overwrite) THEN
        overwrite:= TRUE; name:= saveName;
      END; (*IF name = NIL*)
    END; (*WHILE*)
    IF Std(name) THEN wr:= Stdio.stdout
    ELSE 
      TRY
        wr:= FileStream.OpenWrite(name);
      EXCEPT ELSE
        SIO.PutText("Error at SF.OpenWrite\n");
      END; (*TRY*)
    END; (*IF name*)
    RETURN wr;
  END OpenWrite;

  PROCEDURE OpenAppend(name: TEXT := NIL; prompt:= AppPrompt): Writer =
  VAR wr: Writer := NIL;
  BEGIN
    IF name = NIL THEN name:= GetFileName(prompt) END;
    IF Std(name) THEN wr:= Stdio.stdout
    ELSE
      TRY
        wr:= FileStream.OpenAppend(name)
      EXCEPT ELSE
        SIO.PutText("Error at SF.OpenAppend\n");
      END; (*TRY*)
    END;
    RETURN wr;
  END OpenAppend;

  PROCEDURE FileExists(name: TEXT): BOOLEAN =
  VAR e: BOOLEAN := TRUE;
  BEGIN
    TRY
      Rd.Close(FileStream.OpenRead(name));
    EXCEPT
      Rd.Failure => e:= FALSE
    END; (*TRY*)
    RETURN e
  END FileExists;

  PROCEDURE CloseRead(VAR rd: Reader) =
  BEGIN
    IF (rd # NIL) AND (rd # Stdio.stdin) THEN 
      TRY
        Rd.Close(rd)
      EXCEPT ELSE
        SIO.PutText("Error at SF.CloseRead\n");
      END; (*TRY*)    
      rd:= NIL;
    END; (*IF rd # NIL*)
  END CloseRead;

  PROCEDURE CloseWrite(VAR wr: Writer) =
  BEGIN
    IF (wr = NIL) OR (wr = Stdio.stdout) THEN SIO.Flush()
    ELSE
      TRY
        Wr.Close(wr)
      EXCEPT ELSE
        SIO.PutText("Error at SF.CloseWrite\n");
      END; (*TRY*)
      wr:= NIL;
    END; (*IF wr = NIL*)
  END CloseWrite;

BEGIN
END SF.
