(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created by stolfi on Thu Sep  7 23:20:36 PDT 1989           *)
(* Last modified on Fri Mar 13 14:54:16 PST 1992 by muller     *)
(*      modified on Thu Oct 25 10:31:29 PDT 1990 by stolfi     *)

INTERFACE RGBSortPrivate;

(* Private declarations for RGBSort procedures. *)

FROM RGBSort IMPORT Table, DistFn, CheckProc;

CONST
  NullIndex = LAST (CARDINAL); (* Null array index *)

TYPE
  SortProc = PROCEDURE (
    READONLY color: Table; 
    READONLY model: Table; 
    READONLY weight: ARRAY OF REAL; 
    dist: DistFn; 
    parm: REAL; 
    VAR (*IO*) credit: CARDINAL; 
    tolerance: REAL; 
    VAR (*IO*) pos: ARRAY OF CARDINAL; (* pos[p] where color[p] should go *)
    VAR (*IO*) ev: ARRAY OF REAL;      (* Cost of match edges *)
    check: CheckProc := NIL;
    checkData: REFANY := NIL;
  ) RAISES {};

PROCEDURE Mismatch (
    READONLY color: Table; 
    p: CARDINAL; 
    READONLY model: Table;
    READONLY weight: ARRAY OF REAL; 
    q: CARDINAL; 
    dist: DistFn; 
    parm: REAL;
    tolerance: REAL
  ): REAL RAISES {};
  (* 
    Computes the mismatch between rgb[p] and model[q]. *)

END RGBSortPrivate.

