
Wheel::usage = "Wheel[l, r] gives a Circle3D of radius r, centre at the 
midpoint of the line l, and plane normal to l. Wheel[l, r] gives a list of 
Circle3D's if l or r are lists."

( Wheel[Line @ {p_, q_}, r_?NumberQ] := 
	Translate[(p + q) / 2] @ Apply[Circle3D, r {$o, $i, $j}] 
	/; Cross[$k, q - p] == $o 
)

( Wheel[Line @ {p_, q_}, r_?NumberQ] := Translate[(p + q) / 2] @
	Rotate[
		Angle[$k, q - p], 
		Line @ {$o, Cross[$k, q - p]}
	]
		[Apply[Circle3D, r {$o, $i, $j}]]
)

Wheel[l_List, r_?NumberQ] := Wheel[#, r]& /@ l

Wheel[l_, r_List] := Flatten[Wheel[l, #]& /@ r]

