
PreDraw3D::usage = "PreDraw3D[f] prepares the figure f for drawing in three 
dimensions."

( PreDraw3D[m_] := m 
	/; MemberQ[{Point, Polygon, GrayLevel, RGBColor, PointSize, 
	AbsolutePointSize, Thickness, AbsoluteThickness, FaceForm, EdgeForm}, 
	Head @ m] )

PreDraw3D @ Text[___] := {}

PreDraw3D @ Point @ {x_, y_} := Point @ {x, y, 0.}

PreDraw3D @ l_Line := l

( PreDraw3D @ Circle[c:{_, _, _}, r_] := 
	PreDraw3D @ Circle3D[c, c + r $i, c + r $j] )

( PreDraw3D @ Circle3D[c_, d_, e_] := 
	Line @ Map[c + Cos[#] (d - c) + Sin[#] (e - c) &, 
	2 N[Pi] Range[0, 1, 1 / $PointsOnCircle]] )

( PreDraw3D @ Plane @ {p_, q_, r_} := 
	PreDraw3D @ OutlinePolygon[Polygon @ { q, r, 2 p - q, 2 p - r}, .8] )

( PreDraw3D @ Sphere[c:{_, _, _}, r_] := Block[
	{v, d, e},
	v = ViewPoint /. Options[Graphics3D];
	{d, e} = Translate[Rotate[r {$i, $j}, Cross[$k, v], Angle[$k, v]], c];
	PreDraw3D @ Circle3D[c, d, e] ] )

PreDraw3D @ h_List := PreDraw3D /@ h


