
Perpendicular::usage = "Perpendicular[p, l] is the line at right angles to l 
passing through the point p."

( Perpendicular[p:{_, _, _}, l:Line @ {q_, r_}] := Block[{s, a, b},
	s = {-$j, $i, $k};
	a = s . (q - p) + p;
	b = s . (r - p) + p;
	Stretch[Line[{a, b}], LineLength[l]] ] /;  Distance[p, l] == 0 )

( Perpendicular[p:{_, _, _}, l_Line] := Line[{p, Project[p, l]}] 
	/; Distance[p, l] > 0 )

Perpendicular[l_Line, p:{_, _, _}] := Perpendicular[p, l]

