 
Invert::usage = "Invert[u][g] is the inversion of the figure g in the 
circle or sphere u."

( Invert[u:Sphere[d_, _]] @ Circle3D[c_, a_, b_] := Circumcircle @ Invert[u] @ 
	Take[
		Complement[
			{a, b, 2 c - a, 2 c - b}, 
			{d}
		], 
		3
	]
)

( Invert[u:Sphere[c_, _]] @ Plane @ {p_, q_, r_} := Circumsphere @ Invert[u] @
	Take[
		Complement[
			{p, q, r, (p + q) / 2, (q + r) / 2}, 
			{c} 
		], 
		4 
	]
)

( Invert[u_Sphere[c_, _]] @ Sphere[d_, s_] := Circumsphere @ Invert[u] @ 
	Take[
		Complement[
			Translate[
				s {$i, $j, $k, Sqrt[2.] ($i + $j), 
					Sqrt[2.] ($j + $k)}, 
				d
			], 
			{c}
		], 
		4
	]
)

