/**********************************************************
 * FILE STACK.C version 1.00  - 05/10/94 -
 *
 * DESCRIPTION:
 *  contains stack's functions.
 *
 * NOTES:
 *
 * Copyright 1993 by EZ Software 
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of EZ Software 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific written prior permission. 
 * EZ Software makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * EZ Software DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, 
 * IN NO EVENT SHALL EZ Software BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 *
 *  Original Author: Laurent Chavey, EZ Software 
 *           (chavey@cis.udel.edu)
 *            june, 1993
 *
 *
 * UPDATES:
 *         05/15/95 - removed stknew, stkfree, stknumber, stkdump.
 *                    these are now macros.
 *                  - the stack is derived from teh linklist.
 **********************************************************/

#define STACK
#include "stack.h"

/********************* PRIMITIVES ***********************/

/*********************************************************
 * FUNCTION:
 *  stkpush.
 *
 * PROTOTYPE:
 *  int stkpush(stack *, void *);
 *
 * PARAMETERS:
 *  stack    *lpStackName  Stack definition.
 *  void     *lpValue      Value to be inserted.
 *
 * RETURN:
 *  int   STKNOERROR.
 *        STKGENERROR error inserting, out of heap.
 *
 * DESCRIPTION:
 *  add a new element to the to of the stack.
 *
 * NOTES:
 *
 * UPDATES:
 *          05/15/95 - just a wrapper arroun the linklist.
 *
 *********************************************************/
int stkpush(lpStackName, lpValue)
stack *lpStackName;
void  *lpValue;
{
   llsetbeg(lpStackName);
   return(lladd(lpStackName,lpValue,LLPREV));
}


/*********************************************************
 * FUNCTION:
 *  stkpop.
 *
 * PROTOTYPE:
 *  int stkpop(stack *, stackelement *);
 *
 * PARAMETERS:
 *  stack *lpStackName   Stack definition.
 *  void  *lpData        Data returned.
 * 
 * RETURN:
 *  int  STKNOERROR.
 *       STKEMPTY    stack is empty.
 *
 * DESCRIPTION:
 *  remove the data from the top of the stack.
 *
 * NOTES:
 *        there must be memory space in passed *lpData
 *        to copy to it the data from the stack. Unlike
 *        the link list, the returned data is the data
 *        that was on the stack, and not a pointer to it.
 *
 * UPDATES:  
 *         05/15/95 - made it a wrapp arround the linklist.
 *
 *********************************************************/
int stkpop(lpStackName, lpData)
stack  *lpStackName;
void   *lpData;
{
   int          nError = STKEMPTY;
   void         *lpListData;

   llsetbeg(lpStackName);
   if(lpListData = llgetcur(lpStackName))
   {
      memcpy(lpData,lpListData,lpStackName->nDataSize);
      lldelcur(lpStackName);   
      nError = STKNOERROR;
   }
   
   return(nError);
}

