/**********************************************************
 * FILE LINKLIST.H version 1.05 06/01/95
 *
 * DESCRIPTION:
 *  contains link list defines and prototypes.
 *
 * NOTES:
 *
 * Copyright 1993 by EZ Software 
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of EZ Software 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific written prior permission. 
 * EZ Software makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * EZ Software DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, 
 * IN NO EVENT SHALL EZ Software BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 *
 *  Original Author: Laurent Chavey, EZ Software 
 *           (chavey@cis.udel.edu)
 *            june, 1993
 *
 * UPDATES:
 *          05/15/95 - modified error code to be <= 0.
 *                   - added prototypes for llload and llsave.
 *                   - modified prototype of lladdfind to return an int.
 *                   - added ncompare to linklist stucture.
 *          04/13/95 - added support for find function >,<,=.
 *                   - added a parameter to find function.
 *          10/13/94 - added function for circular link list.
 *                     llgetwnext, llgetwprev.
 *          01/20/94 - changes search and Search to compare, Compare.
 *                   - added support for multiple compare functions.
 *                   - added Dump function.
 *                   - changed prototype, use X_ for extern.
 *                   - added parameter to add function.
 *                   - added error defines.
 *                   - added add defines.
 *                   - removed nSiize param from lladd, added nsize
 *                     to linklist struct, and to llnew function.
 *
 **********************************************************/
#ifndef LINKLIST_H
#define LINKLIST_H

#include <malloc.h>
#include <stdio.h>
#include <memory.h>

/*************** PARAM **********************************/
#define LLNEXT    1
#define LLPREV    2

/* find function return values */
#define LLFOUND    1
#define LLNOTFOUND 0

/* find function querry types */
#define LLGREATER  1
#define LLLESS     2
#define LLEQUAL    3

/************** ERROR **********************************/
#define LLNOERROR    0
#define LLGENERROR   -1
#define LLINVPARA    -2
#define LLFILEERROR  -3
#define LLMAXERROR   -3

/************* STRUCTURE *******************************/
typedef struct LinkElement
{
   struct LinkElement *lpNext;
   struct LinkElement *lpPrevious;
   void  *lpData;
} linkelement;

typedef struct 
{
   linkelement *lpHead;
   linkelement *lpTail;
   linkelement *lpCurrent;
   linkelement *lpSave;
   int          nDataSize;
   int          nCompare;
   int          (** lpfnCompare)(void *, void *, int);
} linklist;

/*********************************************************
   MACROS
*********************************************************/
#define lldelcur(X)  lldelete(X,X->lpCurrent)            /* delete current */
#define llgetpos(X)  X->lpCurrent                        /* get current position */
#define llgetcur(X)  llget(X->lpCurrent)                 /* get data at current pos */
#define llsetbeg(X)  X->lpCurrent = X->lpHead            /* set current to head */
#define llsetend(X)  X->lpCurrent = X->lpTail            /* set current to tail */
#define llnext(X)    X->lpCurrent = X->lpCurrent->lpNext /* go to next link */
#define llprev(X)    X->lpCurrent = X->lpCurrent->lpPrev /* go to previous link */
#define llsavcur(X)  X->lpSave    = X->lpCurrent         /* save current position*/
#define llrescur(X)  X->lpCurrent = X->lpSave            /* restore current position */
#ifdef LINKLIST

   #define X_

   #undef LINKLIST
#else
   #define X_ extern
#endif

   /*********************** PRIMITIVES ******************/
   X_ linklist    *llnew         (int, int);
   X_ int         llfree         (linklist *);
   X_ int         lladd          (linklist *, void *, int);
   X_ int         lldelete       (linklist *, linkelement *);
   X_ int         llnumber       (linklist *);
   X_ void        *llget         (linkelement *);
   X_ int         llsave         (linklist *, int (*)(), FILE *);
   X_ int         llload         (linklist **, int (*)(), FILE *);

   /*********************** EVOLVES ********************/
   X_ void        *llgetnext     (linklist *);
   X_ void        *llgetwnext    (linklist *);
   X_ void        *llgetprev     (linklist *);
   X_ void        *llgetwprev    (linklist *);
   X_ void        *llfind        (linklist *, void *, int, int);
   X_ int         lladdfind      (linklist *,int (*)(), int);

   /*********************** DEBUG **********************/
   X_ int         lldump         (linklist *);

   #undef X_
#endif
