/**********************************************************
 * FILE STACK.H version 1.05 06/01/95
 *
 * DESCRIPTION:
 *  contains all stack's defines and prototypes.
 *
 * NOTES:
 * 
 * Copyright 1993 by EZ Software 
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of EZ Software 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific written prior permission. 
 * EZ Software makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * EZ Software DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, 
 * IN NO EVENT SHALL EZ Software BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 *
 *  Original Author: Laurent Chavey, EZ Software 
 *           (chavey@cis.udel.edu)
 *            june, 1993
 *
 *  UPDATES:
 *          05/15/95 - at last the stack is a derived type
 *                     from the linklist.
 *
 **********************************************************/
#ifndef STACK_H
#define STACK_H

#include <malloc.h>
#include <stdio.h>
#include <memory.h>
#include <linklist.h>

/*************** PARAM **********************************/

/************** ERROR **********************************/
#define STKNOERROR   LLNOERROR
#define STKGENERROR  LLGENERROR
#define STKINVPARA   LLINVPARA
#define STKEMPTY     LLMAXERROR-1

/************* STRUCTURE *******************************/
typedef linklist stack;

/*********************************************************
   MACROS
*********************************************************/
#define stknew(X)    llnew(0,X)
#define stkfree(X)   llfree(X)
#define stknumber(X) llnumber(X)
#define stkdump(X)   lldump(X)

#ifdef STACK 

   #define X_ 

   #undef STACK 
#else
   #define X_ extern
#endif

   /*********************** PRIMITIVES ******************/
   X_ int         stkpush        (stack *, void *);
   X_ int         stkpop         (stack *, void *);

   #undef X_
#endif


