/**********************************************************
 * FILE QUEUE.C version 1.05  - 06/01/95 -
 *
 * DESCRIPTION:
 *  contains queue's functions.
 *
 * NOTES:
 *
 * Copyright 1993 by EZ Software 
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided 
 * that the above copyright notice appear in all copies and that both the 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of EZ Software may
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific written prior permission. 
 * EZ Software makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * EZ Software DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, 
 * IN NO EVENT SHALL EZ Software BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 
 * SOFTWARE.
 *
 *
 *  Original Author: Laurent Chavey, EZ Software 
 *           (chavey@cis.udel.edu)
 *            june, 1993
 *
 * UPGRADES: 
 *           05/15/95 - modified function name qinsert qremove to qenqueue 
 *                      and qdequeue.
 *                    - functiona are derived from linklist.
 *
 **********************************************************/

#include "queue.h"

/********************* PRIMITIVES ***********************/

/*********************************************************
 * FUNCTION:
 *  qenqueue.
 *
 * PROTOTYPE:
 *  int qenqueue(queue *, void *);
 *
 * PARAMETERS:
 *  queue    *lpQueueName  queue definition.
 *  void     *lpValue      Value to be inserted.
 *
 * RETURN:
 *  int   QNOERROR.
 *        QGENERROR error inserting, out of heap.
 *
 * DESCRIPTION:
 *  add a new element to the back of the queue.
 * which is the head of the linklist
 *
 * NOTES:
 *
 * UPDATES: 
 *          05/15/95 - added support for derived function
 *                     from linklist.
 *
 *********************************************************/
int qenqueue(lpQueueName, lpValue)
queue *lpQueueName;
void  *lpValue;
{
   llsetbeg(lpQueueName);
   return(lladd(lpQueueName,lpValue,LLPREV));
}


/*********************************************************
 * FUNCTION:
 *  qdequeue.
 *
 * PROTOTYPE:
 *  int qdequeue(queue *, queueelement *);
 *
 * PARAMETERS:
 *  queue *lpQueueName   queue definition.
 *  void  *lpData        data returned.
 *
 * RETURN:
 *  int  QNOERROR.
 *       QEMPTY    queue is empty.
 *
 * DESCRIPTION:
 *  remove the data from the front of the queue.
 * which is the tail of the list
 *
 * NOTES:
 *
 * UPDATES:  
 *          05/15/95 - added support for derived function
 *                     from linklist.
 *
 *********************************************************/
int qdequeue(lpQueueName, lpData)
queue  *lpQueueName;
void   *lpData;
{
   void  *lpListData;
   int    nError = QEMPTY;

   llsetend(lpQueueName);
   if(lpListData = llgetcur(lpQueueName))
   {
      memcpy(lpData,lpListData,lpQueueName->nDataSize);
      lldelcur(lpQueueName);
      nError = QNOERROR;
   }
   return(nError);
}

