/*
 * strdup.c -- duplicate string
 *
 * Part of publib.
 * "@(#)publib-port:strdup.c,v 1.2 1994/02/03 17:43:18 liw Exp"
 */

#include <assert.h>
#include <stdlib.h>
#include <string.h>

char *strdup(const char *s) {
	size_t n;
	char *p;

	assert(s != NULL);

	n = strlen(s) + 1;
	p = malloc(n);
	if (p != NULL)
		memcpy(p, s, n);
	return p;
}
