/*
 * ba_and_ba.c -- and a set with another set
 *
 * Part of publib.  See man page for more information
 * "@(#)publib-bitarr:ba_and_ba.c,v 1.2 1993/11/29 19:41:40 liw Exp"
 */

#include <assert.h>
#include <string.h>
#include "publib/bitarr.h"

void ba_and_ba(Bitarr *u1, const Bitarr *u2) {
	size_t i, size, u1size;

	assert(u1 != NULL);
	assert(u2 != NULL);
	assert(u1->rnglen == 0 || u1->w != NULL);
	assert(u2->rnglen == 0 || u2->w != NULL);

	u1size = ba_num2word(u1->rnglen);
	size = ba_num2word(u2->rnglen);
	if (u1size < size)
		size = u1size;
	for (i = 0; i < size; ++i)
		u1->w[i] &= u2->w[i];
	if (size < u1size)
		memset(u1->w + size, 0, u1size - size);
}
