/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"
#include <X11/Xatom.h>
#include <X11/Xproto.h>

#include "bitmaps/leftarrow.xbm"
#include "bitmaps/rightarrow.xbm"
#include "bitmaps/uparrow.xbm"
#include "bitmaps/downarrow.xbm"
#include "bitmaps/plus.xbm"
#include "bitmaps/minus.xbm"

/* Functions used in this file */
XtCallbackProc expose_cback();
XtCallbackProc resize_cback();
XtCallbackProc dotplot_on_cback();
XtCallbackProc dotplot_off_cback();
XtCallbackProc xyplot_on_cback();
XtCallbackProc xyplot_off_cback();
XtCallbackProc spin_on_cback();
XtCallbackProc spin_off_cback();
XtCallbackProc grand_tour_on_cback();
XtCallbackProc grand_tour_off_cback();
XtCallbackProc scaling_cback();
XtCallbackProc brush_cback();
XtCallbackProc identify_cback();
XtCallbackProc magnify_cback();
XtCallbackProc add_axes_cback();
XtCallbackProc place_ndata_popup();
XtCallbackProc place_savedata_popup();
XtCallbackProc link_brush_cback();
XtCallbackProc link_ident_cback();
XtCallbackProc link_tour_cback();
XtCallbackProc jump_brush_cback();
XtCallbackProc reshape_brush_cback();
XtCallbackProc carry_vars_cback();
XtCallbackProc print_panel_cback();
XtCallbackProc subset_panel_cback();
XtCallbackProc store_resources_cback();
XtCallbackProc help_cback();
XtCallbackProc exit_panel_cback();
XtCallbackProc exit_solo_cback();
XtCallbackProc showlines_cback(), showpoints_cback();
XtCallbackProc line_editor_cback();
void add_pb_help();
void update_cprof_plot();
void update_sticky_ids();
void realloc_tform();
XtConvertSelectionProc pack_ids();
void announce_ids();
void quickplot_once();
void plot_once();
/* */

static Widget form1, main_panel, sub_panel[2];
static Widget main_cmda[9], main_cmdb[5] ;
static Widget options_popup, oframe, options_mgr, options_var[17];

#define DOTPLOT main_cmda[0]
#define XYPLOT main_cmda[1]
#define ROTATE main_cmda[2]
#define TOUR main_cmda[3]
#define SCALE main_cmda[4]
#define BRUSH main_cmda[5]
#define IDENTIFY main_cmda[6]
#define EDIT_LINES main_cmda[7]
/*
#define MAGNIFY main_cmda[7]
#define EDIT_LINES main_cmda[8]
*/
#define OPTIONS main_cmdb[0]
#define HELP main_cmdb[1]
#define EXIT main_cmdb[2]

#define ADDAXES        options_var[0]
#define SHOWPOINTS     options_var[1]
#define SHOWLINES      options_var[2]
#define LINKBRUSH      options_var[3]
#define LINKIDENT      options_var[4]
#define LINKTOUR       options_var[5]
#define JUMPBRUSH      options_var[6]
#define RESHAPEBRUSH   options_var[7]
#define CARRYVARS      options_var[8]
#define NEWDATA        options_var[9]
#define WRITEDATA      options_var[10]
#define PRINTPLOTWIN   options_var[11]
#define SUBSETDATA     options_var[12]
#define STORERESOURCES options_var[13]
#define CLOSE          options_var[14]

void
init_options(xg)
  xgobidata *xg;
{
  xg->linked_brushing = (Boolean) appdata.linkBrush;
  xg->linked_identify = (Boolean) appdata.linkIdentify;
  xg->linked_touring = (Boolean) appdata.linkTour;
  xg->is_axes = (Boolean) appdata.showAxes;
  xg->plot_the_points = (Boolean) appdata.showPoints;
  xg->connect_the_points = (Boolean) appdata.showLines;
  xg->carry_vars = (Boolean) appdata.carryVars;
  xg->jump_brush = (Boolean) appdata.jumpBrush;
  xg->reshape_brush = (Boolean) appdata.reshapeBrush;
}


void
set_mono(w)
  Widget w;
{
  XtVaSetValues(w,
    XtNforeground, appdata.fg,
    XtNbackground, appdata.bg,
    XtNborderColor, appdata.fg,
    NULL);
}

Widget
CreateCommand(xg, label, sensitive, href, vref, parent, helpLabel)
  xgobidata *xg;
  char *label, *helpLabel;
  Boolean sensitive;
  Widget href, vref;
  Widget parent;
{
  Widget pb;

  if (mono)
    pb = XtVaCreateWidget("Command",
      commandWidgetClass, parent,
      XtNlabel, (String) label,
      XtNsensitive, (Boolean) sensitive,
      XtNfromHoriz, (Widget) href,
      XtNfromVert, (Widget) vref,
      XtNforeground, appdata.fg,
      XtNbackground, appdata.bg,
      XtNborderColor, appdata.fg,
      NULL);
  else
    pb = XtVaCreateWidget("Command",
      commandWidgetClass, parent,
      XtNlabel, (String) label,
      XtNsensitive, (Boolean) sensitive,
      XtNfromHoriz, (Widget) href,
      XtNfromVert, (Widget) vref,
      NULL);

  add_pb_help(&xg->nhelpids.pb, pb, helpLabel);
  return(pb);
}

Widget
CreateToggle(xg, label, sensitive,
href, vref, radioref,
set, type, parent, helpLabel)
  xgobidata *xg;
  char *label, *helpLabel;
  Boolean sensitive, set;
  Widget href, vref, radioref;
  int type;
  Widget parent;
{
  Widget pb;
  char name[8];

  /*
   * Using the fallback resources, we force some
   * toggle widgets to follow "one of many" behavior
   * while others are permitted to be unselected.
  */
  if (type == ONE_OF_MANY)
    strcpy(name, "Toggle");
  else
    strcpy(name, "Command");

  if (mono)
    pb = XtVaCreateWidget(name,
      toggleWidgetClass, parent,
      XtNlabel, (String) label,
      XtNsensitive, (Boolean) sensitive,
      XtNfromHoriz, (Widget) href,
      XtNfromVert, (Widget) vref,
      XtNradioGroup, (Widget) radioref,
      XtNstate, (Boolean) set,
      XtNforeground, appdata.fg,
      XtNbackground, appdata.bg,
      XtNborderColor, appdata.fg,
      NULL);
  else
    pb = XtVaCreateWidget(name,
      toggleWidgetClass, parent,
      XtNlabel, (String) label,
      XtNsensitive, (Boolean) sensitive,
      XtNfromHoriz, (Widget) href,
      XtNfromVert, (Widget) vref,
      XtNradioGroup, (Widget) radioref,
      XtNstate, (Boolean) set,
      NULL);

  add_pb_help(&xg->nhelpids.pb, pb, helpLabel);
  return(pb);
}

Boolean
current_mode(w)
  Widget w;
{
  Boolean state;
/*
 * Get the value of state for w.
*/
  XtVaGetValues(w,
    XtNstate, &state,
    NULL);

  return(!state);
}

Boolean
tour_on(xg)
  xgobidata *xg;
{
  Boolean on;

  XtVaGetValues(TOUR, XtNstate, &on, NULL);
  return(on);
}

void
turn_on_showlines(xg)
  xgobidata *xg;
{
  XtCallCallbacks(SHOWLINES, XtNcallback, (XtPointer) xg);
  XtVaSetValues(SHOWLINES, XtNstate, (Boolean) True, NULL);
}

void
make_plotwindow_mouse_labels(xg)
  xgobidata *xg;
{
  xg->spin_mouse = XtVaCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1,
    XtNlabel, (String) "L or M: Move points ",
    NULL);
  if (mono) set_mono(xg->spin_mouse);

  xg->scale_mouse = XtVaCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1,
    XtNlabel, (String) "L: Move pts, M: Shape pts ",
    NULL);
  if (mono) set_mono(xg->scale_mouse);

  xg->brush_mouse = XtVaCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1,
    XtNlabel, (String) "Drag L: paint, M: shape ",
    NULL);
  if (mono) set_mono(xg->brush_mouse);

  xg->identify_mouse = XtVaCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1,
    XtNlabel, (String) "L: Toggle sticky labels ",
    NULL);
  if (mono) set_mono(xg->identify_mouse);

  xg->le_add_mouse = XtVaCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1,
    XtNlabel, (String) "Drag L: Add line, M: Remove last ",
    NULL);
  if (mono) set_mono(xg->le_add_mouse);

  xg->le_delete_mouse = XtVaCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1,
    XtNlabel, (String) "L: Delete line, M: Put it back ",
    NULL);
  if (mono) set_mono(xg->le_delete_mouse);
}

void
make_plot_window(xg)
  xgobidata *xg;
/*
 * PlotWindow: the plot window
*/
{
  xg->workspace = XtVaCreateManagedWidget("PlotWindow",
    labelWidgetClass, xg->box1,
    XtNresizable, (Boolean) True,
    XtNleft, (XtEdgeType) XtChainLeft,
    XtNtop, (XtEdgeType) XtChainTop,
    XtNright, (XtEdgeType) XtRubber,
    XtNbottom, (XtEdgeType) XtRubber,
    XtNfromVert, (Widget) xg->scale_mouse,
    XtNlabel, (String) "",
    NULL);
  if (mono) set_mono(xg->workspace);
  add_pb_help(&xg->nhelpids.pb,
    xg->workspace, "PlotWindow");

  XtAddEventHandler(xg->workspace, ExposureMask,
    FALSE, (XtEventHandler) expose_cback, (XtPointer) xg);
  XtAddEventHandler(xg->workspace, StructureNotifyMask,
    FALSE, (XtEventHandler) resize_cback, (XtPointer) xg);
}

void
turn_on_xyplotting(xg)
  xgobidata *xg;
{
  Boolean state;
/*
 * If we're not xyplotting, execute the callback to turn it on.
*/
  XtVaGetValues(XYPLOT,
     XtNstate, &state,
     NULL);
  if (!state)
  {
    XtCallCallbacks(XYPLOT, XtNcallback, (XtPointer) xg);
    XtVaSetValues(XYPLOT,
      XtNstate, (Boolean) True,
      NULL);
  }
}

void
ndata_reset_main_panel(xg)
  xgobidata *xg;
{
/*
 * Execute the off callback of whichever mode is running, handling
 * the dimensionality modes (xyplotting, spinning, touring) and the
 * other modes (brushing, identify, etc.) separately.  Then turn
 * xyplotting on again at the end.
*/
  Boolean sens = True;
/*
 * If ncols_used > 2, make sure Rotate and Tour are sensitive; otherwise, make
 * sure they're not.
*/
  if (xg->ncols_used <= 2)
    sens = False;

  XtVaSetValues(ROTATE,
    XtNsensitive, sens,
    NULL);
  XtVaSetValues(TOUR,
    XtNsensitive, sens,
    NULL);
}

void
make_arrows(xg)
  xgobidata *xg;
{
  Drawable root_window = RootWindowOfScreen(XtScreen(xg->shell));

  /*
   * Define arrows.  (depth is a global variable)
  */
  leftarr = XCreatePixmapFromBitmapData(display, root_window,
    leftarrow_bits, leftarrow_width, leftarrow_height,
    appdata.fg, appdata.bg, depth);
  rightarr = XCreatePixmapFromBitmapData(display, root_window,
    rightarrow_bits, rightarrow_width, rightarrow_height,
    appdata.fg, appdata.bg, depth);
  uparr = XCreatePixmapFromBitmapData(display, root_window,
    uparrow_bits, uparrow_width, uparrow_height,
    appdata.fg, appdata.bg, depth);
  downarr = XCreatePixmapFromBitmapData(display, root_window,
    downarrow_bits, downarrow_width, downarrow_height,
    appdata.fg, appdata.bg, depth);
  plus = XCreatePixmapFromBitmapData(display, root_window,
    plus_bits, plus_width, plus_height,
    appdata.fg, appdata.bg, depth);
  minus =  XCreatePixmapFromBitmapData(display, root_window,
    minus_bits, minus_width, minus_height,
    appdata.fg, appdata.bg, depth);
}

void
reset_3d_cmds(xg)
  xgobidata *xg;
{
  Boolean sens = True;

  if (xg->ncols_used < 3)
    sens = False;

  XtVaSetValues(ROTATE,
    XtNsensitive, (Boolean) sens,
    NULL);
  XtVaSetValues(TOUR,
    XtNsensitive, (Boolean) sens,
    NULL);
}

/* ARGSUSED */
XtCallbackProc
PopdownOptionsMenu(w, client_data, callback_data)
/*
 * Pop down the options menu.
*/
  Widget w;
  caddr_t client_data;
  caddr_t callback_data;
{
  XtPopdown(options_popup);
}

void
build_options_menu(xg)
  xgobidata *xg;
{
  options_popup = XtVaCreatePopupShell("Options",
    topLevelShellWidgetClass, OPTIONS,
    XtNinput, True,
    XtNtitle, "Options",
    NULL);
  if (mono) set_mono(options_popup);

  oframe = XtVaCreateManagedWidget("Form",
      panedWidgetClass, options_popup,
      XtNorientation, (XtOrientation) XtorientVertical,
      NULL);

  options_mgr = XtVaCreateManagedWidget("Panel",
    formWidgetClass, oframe,
    NULL);
  if (mono) set_mono(options_mgr);

  ADDAXES = (Widget) CreateToggle(xg, "Add axes",
    True, (Widget) NULL, (Widget) NULL, (Widget) NULL,
    appdata.showAxes, ANY_OF_MANY, options_mgr, "AddAxes");
  XtAddCallback(ADDAXES, XtNcallback,
    (XtCallbackProc) add_axes_cback, (XtPointer) xg);

  SHOWPOINTS = (Widget) CreateToggle(xg, "Show points",
    True, (Widget) NULL, (Widget) ADDAXES, (Widget) NULL,
    appdata.showPoints, ANY_OF_MANY, options_mgr, "ShowPoints");
  XtAddCallback(SHOWPOINTS, XtNcallback,
    (XtCallbackProc) showpoints_cback, (XtPointer) xg);

  SHOWLINES = (Widget) CreateToggle(xg, "Show lines",
    True, (Widget) NULL, (Widget) SHOWPOINTS, (Widget) NULL,
    appdata.showLines, ANY_OF_MANY, options_mgr, "ShowLines");
  XtAddCallback(SHOWLINES, XtNcallback,
    (XtCallbackProc) showlines_cback, (XtPointer) xg);

  LINKBRUSH = XtVaCreateWidget("Command",
    toggleWidgetClass, options_mgr,
    XtNlabel, (String) "Link brushing",
    XtNfromVert, (Widget) SHOWLINES,
    XtNvertDistance, (int) 10,
    XtNstate, (Boolean) xg->linked_brushing,
    NULL);
  if (mono) set_mono(LINKBRUSH);
  add_pb_help(&xg->nhelpids.pb, LINKBRUSH, "LinkBrush" );
  XtAddCallback(LINKBRUSH, XtNcallback,
    (XtCallbackProc) link_brush_cback, (XtPointer) xg);

  LINKIDENT = (Widget) CreateToggle(xg, "Link identification",
    True, (Widget) NULL, (Widget) LINKBRUSH, (Widget) NULL,
    xg->linked_identify, ANY_OF_MANY, options_mgr, "LinkIdent");
  XtAddCallback(LINKIDENT, XtNcallback,
    (XtCallbackProc) link_ident_cback, (XtPointer) xg);

  LINKTOUR = (Widget) CreateToggle(xg, "Link touring",
    True, (Widget) NULL, (Widget) LINKIDENT, (Widget) NULL,
    xg->linked_touring, ANY_OF_MANY, options_mgr, "LinkTour");
  XtAddCallback(LINKTOUR, XtNcallback,
    (XtCallbackProc) link_tour_cback, (XtPointer) xg);

  JUMPBRUSH = XtVaCreateWidget("Command",
    toggleWidgetClass, options_mgr,
    XtNlabel, (String) "Brush jumps to pointer",
    XtNfromVert, (Widget) LINKTOUR,
    XtNvertDistance, (int) 10,
    XtNstate, (Boolean) appdata.jumpBrush,
    NULL);
  if (mono) set_mono(JUMPBRUSH);
  add_pb_help(&xg->nhelpids.pb, JUMPBRUSH, "JumpBrush" );
  XtAddCallback(JUMPBRUSH, XtNcallback,
    (XtCallbackProc) jump_brush_cback, (XtPointer) xg);

  RESHAPEBRUSH = (Widget) CreateToggle(xg, "Reshape brush btwn modes",
    True, (Widget) NULL, (Widget) JUMPBRUSH, (Widget) NULL,
    appdata.reshapeBrush, ANY_OF_MANY, options_mgr, "ReshapeBrush");
  XtAddCallback(RESHAPEBRUSH, XtNcallback,
    (XtCallbackProc) reshape_brush_cback, (XtPointer) xg);

  CARRYVARS = (Widget) CreateToggle(xg, "Carry vars btwn modes",
    True, (Widget) NULL, (Widget) RESHAPEBRUSH, (Widget) NULL,
    appdata.carryVars, ANY_OF_MANY, options_mgr, "CarryVars");
  XtAddCallback(CARRYVARS, XtNcallback,
    (XtCallbackProc) carry_vars_cback, (XtPointer) xg);

  NEWDATA = XtVaCreateWidget("Command",
    commandWidgetClass, options_mgr,
    XtNlabel, (String) "Read data",
    XtNfromVert, (Widget) CARRYVARS,
    XtNvertDistance, (int) 10,
    XtNsensitive, (Boolean) !Sprocess,
    NULL);
  if (mono) set_mono(NEWDATA);
  add_pb_help(&xg->nhelpids.pb, NEWDATA, "NewData" );
  XtAddCallback(NEWDATA, XtNcallback,
    (XtCallbackProc) place_ndata_popup, (XtPointer) xg);

  WRITEDATA = (Widget) CreateCommand(xg, "Save data",
    (Boolean) !Sprocess, (Widget) NULL, (Widget) NEWDATA,
    options_mgr, "SaveData");
  XtAddCallback(WRITEDATA, XtNcallback,
    (XtCallbackProc) place_savedata_popup, (XtPointer) xg);

  PRINTPLOTWIN = (Widget) CreateCommand(xg, "Make postscript plot",
    1, (Widget) NULL, (Widget) WRITEDATA,
    options_mgr, "Print");
  XtAddCallback(PRINTPLOTWIN, XtNcallback,
    (XtCallbackProc) print_panel_cback, (XtPointer) xg);

  SUBSETDATA = (Widget) CreateCommand(xg, "Subset data",
    1, (Widget) NULL, (Widget) PRINTPLOTWIN,
    options_mgr, "Subset");
  XtAddCallback(SUBSETDATA, XtNcallback,
    (XtCallbackProc) subset_panel_cback, (XtPointer) xg);

  STORERESOURCES = (Widget) CreateCommand(xg, "Store resources",
    1, (Widget) NULL, (Widget) SUBSETDATA,
    options_mgr, "StoreResources");
  XtAddCallback(STORERESOURCES, XtNcallback,
    (XtCallbackProc) store_resources_cback, (XtPointer) xg);

  XtManageChildren(options_var, 14);

  CLOSE = XtVaCreateManagedWidget("Close",
    commandWidgetClass, oframe,
    XtNshowGrip, (Boolean) False,
    XtNskipAdjust, (Boolean) True,
    XtNlabel, (String) "Click here to dismiss",
    NULL);
  if (mono) set_mono(CLOSE);
  add_pb_help(&xg->nhelpids.pb, CLOSE, "Close" );
  XtAddCallback(CLOSE, XtNcallback,
    (XtCallbackProc) PopdownOptionsMenu, (XtPointer) NULL);

}

/* ARGSUSED */
XtCallbackProc
PopupOptionsMenu(w, xgobi, callback_data)
/*
 * Pop up the options menu.
*/
  Widget w;
  XtPointer *xgobi;
  caddr_t callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;
  Dimension width, height;
  Position x, y;
  static int initd = 0;

  if (!initd)
  {
    XtVaGetValues(w,
      XtNwidth, &width,
      XtNheight, &height,
      NULL);
    XtTranslateCoords(w,
      (Position) (width/2), (Position) (height/2), &x, &y);

    XtVaSetValues(options_popup,
      XtNx, (Position) x,
      XtNy, (Position) y,
      NULL);

    initd = 1;
  }

  XtPopup(options_popup, XtGrabNone);
  XRaiseWindow(display, XtWindow(options_popup));
}

void
make_widgets(xg, parent)
  xgobidata *xg;
  Widget parent;
{
  Boolean sens;
  String accelerator[50];
  XtAccelerators parsed_accelerator;
  String name[20];

  xg->form0 = XtVaCreateManagedWidget("Form0",
    formWidgetClass, xg->shell,
    NULL);
  if (mono) set_mono(xg->form0);

/*
 * Define main_panel, the main control panel
*/
  main_panel = XtVaCreateManagedWidget("MainPanel",
    formWidgetClass, xg->form0,
    XtNleft, (XtEdgeType) XtChainLeft,
    XtNright, (XtEdgeType) XtChainLeft,
    XtNtop, (XtEdgeType) XtChainTop,
    XtNbottom, (XtEdgeType) XtChainTop,
    NULL);
  if (mono) set_mono(main_panel);

/*
 * Panel to contain mutually exclusive commands.
*/
  sub_panel[0] = XtVaCreateWidget("SubPanel",
    formWidgetClass, main_panel,
    NULL);
  if (mono) set_mono(sub_panel[0]);
/*
 * Panel for remaining states or commands.
*/
  sub_panel[1] = XtVaCreateWidget("SubPanel",
    formWidgetClass, main_panel,
    XtNfromHoriz, (Widget) sub_panel[0],
    NULL);
  if (mono) set_mono( sub_panel[1]);

  XtManageChildren(sub_panel, 2);

/*
 * Main panel commands
*/
  DOTPLOT = (Widget) CreateToggle(xg, "DotPlot",
    1, (Widget) NULL, (Widget) NULL, (Widget) NULL, False, ONE_OF_MANY,
    sub_panel[0], "DotPlot");
  XtAddCallback(DOTPLOT, XtNcallback,
    (XtCallbackProc) dotplot_on_cback, (XtPointer) xg);

  strcpy(accelerator, "<KeyPress>D: set() notify()");
  parsed_accelerator = XtParseAcceleratorTable(accelerator);
  XtVaSetValues(DOTPLOT,
    XtNaccelerators, parsed_accelerator,
    NULL);
  XtInstallAllAccelerators(xg->form0, DOTPLOT);

  XYPLOT = (Widget) CreateToggle(xg, "XYPlot",
    1, (Widget) DOTPLOT, (Widget) NULL, DOTPLOT, True, ONE_OF_MANY,
    sub_panel[0], "XYPlot");
  XtAddCallback(XYPLOT, XtNcallback,
    (XtCallbackProc) xyplot_on_cback, (XtPointer) xg);

  strcpy(accelerator, "<KeyPress>X: set() notify()");
  parsed_accelerator = XtParseAcceleratorTable(accelerator);
  XtVaSetValues(XYPLOT,
    XtNaccelerators, parsed_accelerator,
    NULL);
  XtInstallAllAccelerators(xg->form0, XYPLOT);

/*
 * Rotation and grand tour do not work when there are fewer
 * than three columns.
*/
  sens = True;
  if (xg->ncols_used < 3)
    sens = False;

  ROTATE = (Widget) CreateToggle(xg, "Rotate",
    sens, (Widget) XYPLOT, (Widget) NULL, DOTPLOT, False, ONE_OF_MANY,
    sub_panel[0], "Rotate");
  XtAddCallback(ROTATE, XtNcallback,
    (XtCallbackProc) spin_on_cback, (XtPointer) xg);

  strcpy(accelerator, "<KeyPress>R: set() notify()");
  parsed_accelerator = XtParseAcceleratorTable(accelerator);
  XtVaSetValues(ROTATE,
    XtNaccelerators, parsed_accelerator,
    NULL);
  XtInstallAllAccelerators(xg->form0, ROTATE);

  TOUR = (Widget) CreateToggle(xg, "Tour",
    sens, (Widget) ROTATE, (Widget) NULL, DOTPLOT, False, ONE_OF_MANY,
    sub_panel[0], "Tour");
  XtAddCallback(TOUR, XtNcallback,
    (XtCallbackProc) grand_tour_on_cback, (XtPointer) xg);

  strcpy(accelerator, "<KeyPress>T: set() notify()");
  parsed_accelerator = XtParseAcceleratorTable(accelerator);
  XtVaSetValues(TOUR,
    XtNaccelerators, parsed_accelerator,
    NULL);
  XtInstallAllAccelerators(xg->form0, TOUR);

  SCALE = XtVaCreateWidget("Toggle",
    toggleWidgetClass, sub_panel[0],
    XtNlabel, (String) "Scale",
    XtNradioGroup, (Widget) DOTPLOT,
    XtNfromHoriz, (Widget) TOUR,
    XtNhorizDistance, (int) 6,
    NULL);
  if (mono) set_mono(SCALE);
  add_pb_help(&xg->nhelpids.pb, SCALE, "Scale" );
  XtAddCallback(SCALE, XtNcallback,
    (XtCallbackProc) scaling_cback, (XtPointer) xg);

  strcpy(accelerator, "<KeyPress>S: set() notify()");
  parsed_accelerator = XtParseAcceleratorTable(accelerator);
  XtVaSetValues(SCALE,
    XtNaccelerators, parsed_accelerator,
    NULL);
  XtInstallAllAccelerators(xg->form0, SCALE);

  BRUSH = (Widget) CreateToggle(xg, "Brush",
    1, (Widget) SCALE, (Widget) NULL, DOTPLOT, False, ONE_OF_MANY,
    sub_panel[0], "Brush");
  XtAddCallback(BRUSH, XtNcallback,
    (XtCallbackProc) brush_cback, (XtPointer) xg);

  strcpy(accelerator, "<KeyPress>B: set() notify()");
  parsed_accelerator = XtParseAcceleratorTable(accelerator);
  XtVaSetValues(BRUSH,
    XtNaccelerators, parsed_accelerator,
    NULL);
  XtInstallAllAccelerators(xg->form0, BRUSH);

  IDENTIFY = (Widget) CreateToggle(xg, "Identify",
    1, (Widget) BRUSH, (Widget) NULL, DOTPLOT, False, ONE_OF_MANY,
    sub_panel[0], "Identify");
  XtAddCallback(IDENTIFY, XtNcallback,
    (XtCallbackProc) identify_cback, (XtPointer) xg);

  strcpy(accelerator, "<KeyPress>I: set() notify()");
  parsed_accelerator = XtParseAcceleratorTable(accelerator);
  XtVaSetValues(IDENTIFY,
    XtNaccelerators, parsed_accelerator,
    NULL);
  XtInstallAllAccelerators(xg->form0, IDENTIFY);

/*
  MAGNIFY = (Widget) CreateToggle(xg, "Magnify",
    1, (Widget) IDENTIFY, (Widget) NULL, DOTPLOT, False, ONE_OF_MANY,
    sub_panel[0], "Magnify");
  XtAddCallback(MAGNIFY, XtNcallback,
    (XtCallbackProc) magnify_cback, (XtPointer) xg);
*/

  EDIT_LINES = (Widget) CreateToggle(xg, "LineEdit",
    1, (Widget) IDENTIFY, (Widget) NULL, DOTPLOT, False, ONE_OF_MANY,
    sub_panel[0], "LineEdit");
  XtAddCallback(EDIT_LINES, XtNcallback,
    (XtCallbackProc) line_editor_cback, (XtPointer) xg);

  strcpy(accelerator, "<KeyPress>L: set() notify()");
  parsed_accelerator = XtParseAcceleratorTable(accelerator);
  XtVaSetValues(EDIT_LINES,
    XtNaccelerators, parsed_accelerator,
    NULL);
  XtInstallAllAccelerators(xg->form0, EDIT_LINES);

  /*XtManageChildren(main_cmda, 9);*/
  XtManageChildren(main_cmda, 8);

  OPTIONS = (Widget) CreateCommand(xg, "Options",
    1, (Widget) NULL, (Widget) NULL,
    sub_panel[1], "Options");
  XtAddCallback(OPTIONS, XtNcallback,
    (XtCallbackProc) PopupOptionsMenu, (XtPointer) xg);

  strcpy(accelerator, "<KeyPress>O: set() notify()");
  parsed_accelerator = XtParseAcceleratorTable(accelerator);
  XtVaSetValues(OPTIONS,
    XtNaccelerators, parsed_accelerator,
    NULL);
  XtInstallAllAccelerators(xg->form0, OPTIONS);

  HELP = (Widget) CreateCommand(xg, "Help",
    1, (Widget) OPTIONS, (Widget) NULL,
    sub_panel[1], "Help");
  XtAddCallback(HELP, XtNcallback,
    (XtCallbackProc) help_cback, (XtPointer) NULL);

  EXIT = (Widget) CreateCommand(xg, "Exit",
    1, (Widget) HELP, (Widget) NULL,
    sub_panel[1], "Exit");
  if (parent)
    XtAddCallback(EXIT, XtNcallback,
      (XtCallbackProc) exit_panel_cback, (XtPointer) xg);
  else
    XtAddCallback(EXIT, XtNcallback,
      (XtCallbackProc) exit_solo_cback, (XtPointer) xg);

  XtManageChildren(main_cmdb, 3);

/*
 * Paned widget to help users adjust the plot window and the
 * variable selection panel.
*/
  form1 = XtVaCreateManagedWidget("Form1",
    panedWidgetClass, xg->form0,
    XtNfromVert, (Widget) main_panel,
    XtNleft, (XtEdgeType) XtChainLeft,
    XtNright, (XtEdgeType) XtChainRight,
    XtNtop, (XtEdgeType) XtChainTop,
    XtNbottom, (XtEdgeType) XtRubber,
    XtNorientation, (XtOrientation) XtorientHorizontal,
    NULL);
  if (mono) set_mono(form1);

  xg->box0 = XtVaCreateManagedWidget("Box0",
    formWidgetClass, form1,
    XtNmin, 5,
    NULL);
  if (mono) set_mono(xg->box0);

  xg->box1 = XtVaCreateManagedWidget("Box1",
    formWidgetClass, form1,
    XtNmin, 5,
    NULL);
  if (mono) set_mono(xg->box1);

  xg->box2 = XtVaCreateManagedWidget("Box2",
    formWidgetClass, form1,
    XtNmin, 5,
    NULL);
  if (mono) set_mono(xg->box2);
}

#undef DOTPLOT
#undef XYPLOT
#undef ROTATE
#undef TOUR
#undef SCALE
#undef BRUSH
#undef IDENTIFY
#undef MAGNIFY
#undef EDIT_LINES
#undef OPTIONS
#undef HELP
#undef EXIT
#undef ADDAXES
#undef SHOWPOINTS
#undef SHOWLINES
#undef UNLINK
#undef JUMPBRUSH
#undef RESHAPEBRUSH
#undef CARRYVARS
#undef NEWDATA
#undef PRINTPLOTWIN
#undef SUBSETDATA
#undef STORERESOURCES
#undef CLOSE

#undef VTOGGLE
#undef VSELECT
#undef VDESELECT
#undef CTOGGLE
#undef CSELECT
#undef CDESELECT
#undef VSELECTALL
#undef VDESELECTALL
#undef CSELECTALL
#undef CDESELECTALL
