/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions used in this file */
void set_mono();
/* */

/* ARGSUSED */
XtCallbackProc
dismiss_message_cback(w, popup, cback_data)
  Widget w;
  XtPointer *popup;
  caddr_t cback_data;
{
  Widget parent = (Widget) popup;
  /*XtDestroyWidget(XtParent(XtParent(w)));*/
  XtDestroyWidget(parent);
}

void
show_message(message, xg)
  String message;
  xgobidata *xg;
{
  Widget popup, frame, text, done;
  Dimension width, height;
  Dimension wksp_width, wksp_height;
  Position x, y;
  int nreturns;
  int i, j, nchars, start;

  /*
   * Figure out the necessary width and height of the window
   * to contain the message.
  */
  for (i=0, j=0, nchars=0, nreturns=0, start=0; i<strlen(message); i++)
  {
    j++ ;
    if (message[i] == '\n')
    {
      if (j > nchars)
      {
        nchars = j ;
        start = i - j + 1;
      }
      nreturns++ ;
      j = 0;
    }
  }

  width = 20 + XTextWidth(appdata.helpFont, &message[start], nchars) ;
  height = (nreturns + 1) * FONTHEIGHT(appdata.helpFont);

  /*
   * Create the popup itself.
  */
  popup = XtVaCreatePopupShell("Message",
    topLevelShellWidgetClass,
    xg->shell,       /* child of the shell itself? */
    XtNtitle, (String) "XGobi Message Window",
    XtNiconName, (String) "XGobi Message Window",
    NULL);
  if (mono) set_mono(popup);
  /*
   * Create the paned widget.
  */
  frame = XtVaCreateManagedWidget("Form",
    panedWidgetClass, popup,
    XtNorientation, (XtOrientation) XtorientVertical,
    NULL);
  if (mono) set_mono(frame);

  /*
   * Create the text widget.
  */
  text = XtVaCreateManagedWidget("Text",
    asciiTextWidgetClass, frame,
     XtNallowResize, (Boolean) True,
     XtNshowGrip, (Boolean) False,
     XtNtype, (XawAsciiType) XawAsciiString,
     XtNstring, (String) message,
     XtNwidth, (Dimension) width,
     XtNheight, (Dimension) height,
     XtNscrollVertical, (XawTextScrollMode) XawtextScrollWhenNeeded,
     XtNdisplayCaret, (Boolean) False,
     XtNfont, (XFontStruct *) appdata.helpFont,  /* for now */
     NULL);
   if (mono) set_mono(text);

  /*
   * Create the Done button.
  */
  done = XtVaCreateManagedWidget("Done",
    commandWidgetClass, frame,
    XtNshowGrip, (Boolean) False,
    XtNskipAdjust, (Boolean) True,
    XtNlabel, (String) "Click here to dismiss",
    NULL);
  if (mono) set_mono(done);

  XtAddCallback(done, XtNcallback,
    (XtCallbackProc) dismiss_message_cback, (XtPointer) popup);

  /*
   * Place the message in the middle of the plotting window
  */
  XtVaGetValues(xg->workspace,
    XtNwidth, &wksp_width,
    XtNheight, &wksp_height, NULL);
  XtTranslateCoords(xg->workspace,
    (Position) (wksp_width/2), (Position) (wksp_height/2), &x, &y);

  XtVaSetValues(popup,
    XtNx, (Position) (x - width/2),
    XtNy, (Position) (y - height/2),
    NULL);

  XtPopup(popup, XtGrabNone);
  XRaiseWindow(display, XtWindow(popup));
}
