/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions called in this file */
XtConvertSelectionProc pack_rowsinplot_data();
XtConvertSelectionProc pack_brush_data();
XtSelectionDoneProc pack_brush_done();
XtLoseSelectionProc pack_brush_lose();
XtEventHandler brush_button(), brush_motion();
int fclose();
int set_deci();
void SetNiceRange();
void announce_brush_data();
void announce_rows_in_plot();
void assign_points_to_bins();
void dotplot_texture_var();
void draw_brush();
void fname_popup();
void init_brush_size();
void init_erase();
void init_glyph_ids();
void init_line_colors();
void init_tickdelta();
void init_ticks();
int glyph_color_pointtype();
void map_brush();
void map_group_var();
void plane_to_screen();
void plot_once();
void pp_index();
void quickplot_once();
void reset_3d_cmds();
void reset_br_types();
void reset_group_cprof_plot();
void reset_pp_plot();
void update_lims();
void update_sphered();
void update_world();
void world_to_plane();
void make_erase_menu();
void turn_off_section_tour();
void show_message();
/*  */

#define NAMESIZE 15
#define NAMESV(j) (namesv + j*NAMESIZE)

typedef struct {
  int glyphtype, glyphsize;
  unsigned long color;
} colorv;

void
copy_brushinfo_to_senddata(xg)
  xgobidata *xg;
{
/*
 * Fill the vector that is used in linked brushing.  This
 * routine is called when brushing is turned on and will
 * need to be called whenever there is a change in
 * xg->rows_in_plot[].  This same vector is used to transfer
 * all the brushing data or just the rows_in_plot[] vector.
*/
  int i, j, nr = xg->nrows_in_plot;

  xg->senddata = (unsigned long *) XtRealloc((XtPointer) xg->senddata,
    (Cardinal) (2*nr + 3) * sizeof(unsigned long) );

  for (i=0, j=3; i<nr; i++, j++)
  {
    xg->senddata[j] = (unsigned long) xg->rows_in_plot[i];
    xg->senddata[j + nr] = (unsigned long)
      glyph_color_pointtype(xg, xg->rows_in_plot[i]);
  }
}

/* ARGSUSED */
XtCallbackProc
brush_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  if (!xg->is_brushing)
  {
    /* Add event handlers for the workspace widget.  */
    XtAddEventHandler(xg->workspace,
      ButtonPressMask | ButtonReleaseMask,
      FALSE, (XtEventHandler) brush_button, (XtPointer) xg);
    XtAddEventHandler(xg->workspace,
      Button1MotionMask | Button2MotionMask ,
      FALSE, (XtEventHandler) brush_motion, (XtPointer) xg);

    xg->is_brushing = True;
    map_brush(xg, True);

    if (xg->reshape_brush)
      init_brush_size(xg);
    draw_brush(xg);

    assign_points_to_bins(xg);

    copy_brushinfo_to_senddata(xg);

    if (xg->is_tour_section)
      turn_off_section_tour(xg);
  }
  else
  {
    XtDisownSelection( (Widget) xg->workspace,
      (Atom) XG_NEWPAINT,
      (Time) XtLastTimestampProcessed(display));
      /*(XtConvertSelectionProc) pack_brush_data );*/

    xg->is_brushing = False;
    /* Remove event handler for the workspace widget. */
    XtRemoveEventHandler(xg->workspace, XtAllEvents,
      TRUE, (XtEventHandler) brush_button, (XtPointer) xg);
    XtRemoveEventHandler(xg->workspace, XtAllEvents,
      TRUE, (XtEventHandler) brush_motion, (XtPointer) xg);

    /*
     * If we've been using transient brushing, restore
     * all points colors and glyphs to their persistent state.
    */
    if (xg->is_transient)
    {
      int j;
      for (j=0; j<xg->nrows_in_plot; j++)
      {
        xg->glyph_now[j].type = xg->glyph_ids[j].type;
        xg->glyph_now[j].size = xg->glyph_ids[j].size;
        xg->color_now[j] = xg->color_ids[j];
      }
    }

    map_brush(xg, False);
    plot_once(xg);
  }
}

/* ARGSUSED */
XtCallbackProc
brush_points_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->is_point_painting = !xg->is_point_painting;
  quickplot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
brush_active_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->brush_on = !xg->brush_on ;
  quickplot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
brush_lines_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->is_line_painting = !xg->is_line_painting;
  quickplot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
br_perst_cback(w, xgobi, callback_data)
/*
 * Turn persistent brushing on or off.
*/
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->is_persistent = !xg->is_persistent;
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
br_trans_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  /*
   * If transient brushing is being turned off, also
   * restore colors and glyphs to persistent identities.
  */
  if (xg->is_transient)
  {
    int j;
    for (j=0; j<xg->nrows_in_plot; j++)
    {
      xg->glyph_now[j].type = xg->glyph_ids[j].type;
      xg->glyph_now[j].size = xg->glyph_ids[j].size;
      xg->color_now[j] = xg->color_ids[j];
    }
  }

  xg->is_transient = !xg->is_transient;
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
br_erase_cback(w, xgobi, callback_data)
/*
 * Erase brushing:  for now, just disable the choices of brushing
 * type during erase brushing.  At this point, erase is only implemented
 * as a persistent operation.
*/
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  if (!xg->is_erase)
  {
    /*
     * If we've been using transient brushing, restore
     * all points colors and glyphs to their persistent state.
    */
    if (xg->is_transient)
    {
      int j;
      for (j=0; j<xg->nrows_in_plot; j++)
      {
        xg->glyph_now[j].type = xg->glyph_ids[j].type;
        xg->glyph_now[j].size = xg->glyph_ids[j].size;
        xg->color_now[j] = xg->color_ids[j];
      }
    }
    xg->is_erase = True;
  }
  else
    xg->is_erase = False;

  reset_br_types(xg);
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
br_complement_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;
  int j;

  for (j=0; j<xg->nrows_in_plot; j++)
    xg->erased[xg->rows_in_plot[j]] = !xg->erased[xg->rows_in_plot[j]];

  copy_brushinfo_to_senddata(xg);
  if (xg->linked_brushing)
  {
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_NEWPAINT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_brush_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_brush_data(xg);
  }
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
br_undo_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->is_undo = !xg->is_undo;
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
link_brush_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->linked_brushing = !xg->linked_brushing;
}

/* ARGSUSED */
XtCallbackProc
jump_brush_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->jump_brush = !xg->jump_brush;
}

/* ARGSUSED */
XtCallbackProc
reshape_brush_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  xg->reshape_brush = !xg->reshape_brush;
}

/* ARGSUSED */
XtCallbackProc
br_update_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  if (xg->linked_brushing)
  {
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_ROWSINPLOT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_rowsinplot_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_rows_in_plot(xg);
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_NEWPAINT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_brush_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_brush_data(xg);
  }
}

/* ARGSUSED */
XtCallbackProc
reset_brush_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  init_brush_size(xg);
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
reset_point_colors_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;
  int j;

  if (!mono)
  {
    for (j=0; j<xg->nrows; j++)
      xg->color_ids[j] = xg->color_now[j] = plotcolors.fg;
  }

  copy_brushinfo_to_senddata(xg);
  if (xg->linked_brushing)
  {
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_NEWPAINT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_brush_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_brush_data(xg);
  }
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
reset_line_colors_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  if (!mono)
    init_line_colors(xg);
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
reset_glyphs_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  init_glyph_ids(xg);

  copy_brushinfo_to_senddata(xg);
  if (xg->linked_brushing)
  {
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_NEWPAINT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_brush_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_brush_data(xg);
  }
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
reset_erase_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  init_erase(xg);
  if (xg->linked_brushing)
  {
    copy_brushinfo_to_senddata(xg);
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_NEWPAINT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_brush_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_brush_data(xg);
  }
  plot_once(xg);
}

/* ARGSUSED */
XtCallbackProc
br_place_pts_popup(w, xgobi, callback_data)
/*
 * Determine where to place the popup window in which the user enters
 * a filename; invoked before brush_save_pts.
*/
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  (void) strcpy(xg->save_type, SAVE_POINT_COLORS_GLYPHS);
  fname_popup(XtParent(w), xg);
}

static int
find_gid(glyph)
  glyphv *glyph;
{
  int gid = 0;

  gid = NGLYPHSIZES*(glyph->type-1) + glyph->size ;
  return(gid);
}


void
brush_save_pts(w, xg)
  Widget w;
  xgobidata *xg;
{
  char *fname, fnameplus[150], *cid, *namesv;
  int i, j, gid;
  int nameslen = 0;
  long foo;
  FILE *fopen(), *fp;
  char message[200];

  XtVaGetValues(w,
    XtNstring, &fname,
    NULL);

  if (Sprocess)
  {
/*
 * First, the erase vector.
*/
    (void) strcpy(fnameplus, Spath0);
    (void) strcat(fnameplus, fname);
    (void) strcat(fnameplus, ".erase");
    if ( (fp = fopen(fnameplus, "w")) == NULL)
    {
      sprintf(message,
        "The file '%s' can't be opened for writing\n", fnameplus);
      show_message(message, xg);
      return;
    }
    else
    {
      /* "1" indicates an S data structure of one element. */
      (void) fprintf(fp, "%cS data%c", (char) 0 , (char) 1);
      /* "2" indicates type integer. */
      foo = (long) 2;
      if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
        (void) fprintf(stderr, "error 1 in writing erase vector\n");
      /* "nrows" indicates the number of elements. */
      foo = (long) xg->nrows;
      if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
        fprintf(stderr, "error 2 in writing erase vector\n");

      for (j=0; j<xg->nrows; j++)
      {
        foo = (long) xg->erased[j] ;
        if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
          (void) fprintf(stderr, "error 3 in writing erase vector\n");

      }
      if (fclose(fp) == EOF)
        (void) fprintf(stderr, "error 4 in writing erase vector\n");
    }
/*
 * Second, the glyph ids.
*/
    (void) strcpy(fnameplus, Spath0);
    (void) strcat(fnameplus, fname);
    (void) strcat(fnameplus, ".glyphs");
    if ( (fp = fopen(fnameplus, "w")) == NULL)
    {
      sprintf(message,
        "The file '%s' can't be opened for writing\n", fnameplus);
      show_message(message, xg);
      return;
    }
    else
    {
      /* "1" indicates an S data structure of one element. */
      (void) fprintf(fp, "%cS data%c", (char) 0 , (char) 1);
      /* "2" indicates type integer. */
      foo = (long) 2;
      if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
        (void) fprintf(stderr, "error 1 in writing glyph vector\n");
      /* "nrows" indicates the number of elements. */
      foo = (long) xg->nrows;
      if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
        (void) fprintf(stderr, "error 2 in writing glyph vector\n");

      for (j=0; j<xg->nrows; j++)
      {
        foo = (long) find_gid(&xg->glyph_now[j]);
        if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
          (void) fprintf(stderr, "error 3 in writing glyph vector\n");

      }
      if (fclose(fp) == EOF)
        (void) fprintf(stderr, "error 4 in writing glyph vector\n");
    }

    /*
     * Now, the color ids.
    */
    if (!mono)
    {
      (void) strcpy(fnameplus, Spath0);
      (void) strcat(fnameplus, fname);
      (void) strcat(fnameplus, ".colors");
      if ( (fp = fopen(fnameplus, "w")) == NULL)
      {
        sprintf(message,
          "The file '%s' can't be opened for writing\n", fnameplus);
        show_message(message, xg);
        return;
      }
      else
      {
        namesv = (char *) XtMalloc(
          (Cardinal) xg->nrows*NAMESIZE * sizeof(char));
        /* "1" indicates an S data structure of one element. */
        (void) fprintf(fp, "%cS data%c", (char) 0 , (char) 1);
        /* "5" indicates type character. */
        foo = (long) 5;
        if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
          (void) fprintf(stderr, "error 1 in writing glyph vector\n");
        /* "nrows" indicates the number of elements. */
        foo = (long) xg->nrows;
        if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
          (void) fprintf(stderr, "error 2 in writing glyph vector\n");

        for (j=0; j<xg->nrows; j++)
        {
          for (i=0; i<ncolors; i++)
          {
            if (color_nums[i] == xg->color_now[j])
            {
              (void) strcpy(NAMESV(j), color_names[i]);
              break;
            }
          }
          nameslen = nameslen + strlen(NAMESV(j)) + 1;
        }

        foo = (long) nameslen;
        if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
          (void) fprintf(stderr, "error 3 in writing glyph vector\n");

        for (j=0; j<xg->nrows; j++)
          (void) fprintf(fp, "%s%c",  NAMESV(j), (char) 0);
        if (fclose(fp) == EOF)
          (void) fprintf(stderr, "error 4 in writing glyph vector\n");
        XtFree((XtPointer) namesv);
      }
    }
  }

  else     /* if not S */
  {
  /*
   * For a monochrome display, just write out the glyph ids.
   * For a color display, write both glyph id and color name.
   * First, the erase vector.
  */
    (void) strcpy(fnameplus, fname);
    (void) strcat(fnameplus, ".erase");
    if ( (fp = fopen(fnameplus, "w")) == NULL)
    {
      sprintf(message,
        "The file '%s' can't be opened for writing\n", fnameplus);
      show_message(message, xg);
      return;
    }

    for (j=0; j<xg->nrows; j++)
      (void) fprintf(fp, "%d\n", (long) xg->erased[j]);

    fclose(fp);
    /*
     * Next, the glyphs
    */
    (void) strcpy(fnameplus, fname);
    (void) strcat(fnameplus, ".glyphs");
    if ( (fp = fopen(fnameplus, "w")) == NULL)
    {
      sprintf(message,
        "The file '%s' can't be opened for writing\n", fnameplus);
      show_message(message, xg);
    }
    for (j=0; j<xg->nrows; j++)
    {
      gid = find_gid(&xg->glyph_now[j]);
      (void) fprintf(fp, "%d\n", gid);
    }
    fclose(fp);

    if (!mono)
    {
      (void) strcpy(fnameplus, fname);
      (void) strcat(fnameplus, ".colors");
      if ( (fp = fopen(fnameplus, "w")) == NULL)
      {
        sprintf(message,
          "The file '%s' can't be opened for writing\n", fnameplus);
        show_message(message, xg);
        return;
      }
      else
      {
        for (j=0; j<xg->nrows; j++)
        {
          for (i=0; i<xg->nrows; i++)
          {
            if (xg->color_now[j] == color_nums[i])
            {
              cid = color_names[i];
              break;
            }
          }
          (void) fprintf(fp, "%s\n", cid);
        }
      }
      if (fclose(fp) == EOF)
        (void) fprintf(stderr, "error in writing color vector\n");
    }
  }
}

/* ARGSUSED */
XtCallbackProc
br_save_to_group_var(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  int i, k, n, j, groupno;
  int new_color, new_glyph;
  colorv *clusv;
  glyphv glyphs_used[NGLYPHS];
  unsigned long colors_used[NCOLORS+1];
  int nglyphs_used, ncolors_used, nclust;
  int *cols, ncols;

/*
 * Find all glyphs and colors used.
*/
  colors_used[0] = xg->color_ids[0];
  ncolors_used = 1;
  for (i=0; i<xg->nrows; i++)
  {
    new_color = 1;
    for (k=0; k<ncolors_used; k++)
    {
      if (colors_used[k] == xg->color_ids[i])
      {
        new_color = 0;
        break;
      }
    }
    if (new_color)
    {
      colors_used[ncolors_used] = xg->color_ids[i];
      ncolors_used++;
    }
  }

  glyphs_used[0].type = xg->glyph_ids[0].type;
  glyphs_used[0].size = xg->glyph_ids[0].size;
  nglyphs_used = 1;
  for (i=0; i<xg->nrows; i++)
  {
    new_glyph = 1;
    for (k=0; k<nglyphs_used; k++)
    {
      if (glyphs_used[k].type == xg->glyph_ids[i].type &&
        glyphs_used[k].size == xg->glyph_ids[i].size)
      {
        new_glyph = 0;
        break;
      }
    }
    if (new_glyph)
    {
      glyphs_used[nglyphs_used].type = xg->glyph_ids[i].type;
      glyphs_used[nglyphs_used].size = xg->glyph_ids[i].size;
      nglyphs_used++;
    }
  }

  if (ncolors_used * nglyphs_used == 1)  /* no brushing groups */
  {
    /*
     * If there are no brushing groups, set each value = 1.
     * Forget about unmapping the variable, though; it's
     * too excruciating.
    */
    for (i=0; i<xg->nrows; i++)
    {
      xg->tform_data[i][xg->ncols-1] =
        xg->raw_data[i][xg->ncols-1] = 1.0 ;
    }
  }
  else
  {
    xg->ncols_used = xg->ncols;

    clusv = (colorv *)
      XtMalloc((Cardinal) (ncolors_used * nglyphs_used) * sizeof(colorv));
    /*
     * Loop over glyphs and colors to find out how many
     * clusters there are.
    */
    nclust = 0;
    for (k=0; k<nglyphs_used; k++)
    {
      clusv[nclust].glyphtype = glyphs_used[k].type;
      clusv[nclust].glyphsize = glyphs_used[k].size;
      for (n=0; n<ncolors_used; n++)
      {
        new_color = 0;
        /*
         * Loop over all points, looking at glyph and color ids.
         * new clusv group.
        */
        for (i=0; i<xg->nrows; i++)
        {
          /*
           * If we find a pair ...
          */
          if (xg->glyph_ids[i].type == glyphs_used[k].type &&
            xg->glyph_ids[i].size == glyphs_used[k].size &&
            xg->color_ids[i] == colors_used[n])
          {
            new_color = 1;
            /*
             * make sure it's not already a member of clusv[]
            */
            for (j=0; j<nclust; j++)
            {
              if (clusv[j].glyphtype == glyphs_used[k].type &&
                clusv[j].glyphsize == glyphs_used[k].size &&
                clusv[j].color == colors_used[n])
                  new_color = 0;
            }
            break;
          }
        }

        if (new_color)
        {
          clusv[nclust].glyphtype = glyphs_used[k].type;
          clusv[nclust].glyphsize = glyphs_used[k].size;
          clusv[nclust].color = colors_used[n];
          nclust++;
        }
      }
    }
    map_group_var(xg);

    /*
     * If there are clusters, this sets the data to reflect that.
    */
    for (n=0; n<nclust; n++)
    {
      for (i=0; i<xg->nrows; i++)
      {
        if (xg->glyph_ids[i].type == clusv[n].glyphtype &&
          xg->glyph_ids[i].size == clusv[n].glyphsize &&
          xg->color_ids[i] == clusv[n].color)
        {
          xg->tform_data[i][xg->ncols-1] =
            xg->raw_data[i][xg->ncols-1] = (float) n;
        }
      }
    }
    XtFree((XtPointer) clusv);
  }

  reset_3d_cmds(xg);
  /* tour_alloc() should have been executed in any case */

/*
 * Run the data through the pipeline.
*/
  /*
   * Figure out which group the group variable belongs to.
   * This isn't meaningful yet, but it will be if we implement
   * an interactive way to reset groups.
  */
  ncols = 0;
  groupno = xg->vgroup_ids[xg->ncols-1];
  cols = (int *) XtMalloc((unsigned) xg->ncols_used * sizeof(int));
  for (j=0; j<xg->ncols_used; j++)
  {
    if (xg->vgroup_ids[j] == groupno)
      cols[ncols++] = j;
  }

  if (xg->ncols_used > 2)
    update_sphered(xg, cols, ncols);
  update_lims(xg);
  update_world(xg);

  if (xg->is_xyplotting)
  {
    init_tickdelta(xg);
    init_ticks(&xg->xy_vars, xg);
  }
  else if (xg->is_dotplotting)
  {
    init_tickdelta(xg);
    init_ticks(&xg->dotplot_vars, xg);
  }

  /*
   * This will add the extra variable to the case profile plot
   * if xgobi is case profile plotting.
  */
  reset_group_cprof_plot(xg);

  /*
   * This part is only necessary if the group column is plotted,
  */
  if (xg->varchosen[xg->ncols-1] == True)
  {
    if (xg->is_dotplotting)
      dotplot_texture_var(xg);
    world_to_plane(xg);
    plane_to_screen(xg);
    assign_points_to_bins(xg);
    plot_once(xg);
  }

  XtFree((XtPointer) cols);
}

/* ARGSUSED */
XtCallbackProc
br_place_lines_popup(w, xgobi, callback_data)
/*
 * Determine where to place the popup window in which the user enters
 * a filename; invoked before brush_save_lines.
*/
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  (void) strcpy(xg->save_type, SAVE_LINE_COLORS);
  fname_popup(XtParent(w), xg);
}

void
brush_save_lines(w, xg)
  Widget w;
  xgobidata *xg;
{
  char *fname, fnameplus[150], *cid, *namesv;
  char message[200];
  int i, j;
  int nameslen = 0;
  long foo;
  FILE *fopen(), *fp;

  XtVaGetValues(w,
    XtNstring, &fname,
    NULL);

  if (Sprocess)
  {
    /*
     * Now, the color ids.
    */
    if (!mono)
    {
      (void) strcpy(fnameplus, Spath0);
      (void) strcat(fnameplus, fname);
      (void) strcat(fnameplus, ".linecolors");
      if ( (fp = fopen(fnameplus, "w")) == NULL)
      {
        sprintf(message,
          "The file '%s' can't be opened for writing\n", fnameplus);
        show_message(message, xg);
        return;
      }
      else
      {
        namesv = (char *) XtMalloc(
          (Cardinal) xg->nlinks*NAMESIZE * sizeof(char));
        /* "1" indicates an S data structure of one element. */
        (void) fprintf(fp, "%cS data%c", (char) 0 , (char) 1);
        /* "5" indicates type character. */
        foo = (long) 5;
        if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
          (void) fprintf(stderr, "error 1 in writing line color vector\n");
        /* "nrows" indicates the number of elements. */
        foo = (long) xg->nlinks;
        if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
          (void) fprintf(stderr, "error 2 in writing line color vector\n");

        for (j=0; j<xg->nlinks; j++)
        {
          for (i=0; i<ncolors; i++)
          {
            if (color_nums[i] == xg->line_color_now[j])
            {
              (void) strcpy(NAMESV(j), color_names[i]);
              break;
            }
          }
          nameslen = nameslen + strlen(NAMESV(j)) + 1;
        }

        foo = (long) nameslen;
        if (fwrite((char *) &foo, sizeof(foo), 1, fp) == 0)
          (void) fprintf(stderr, "error 3 in writing line color vector\n");

        for (j=0; j<xg->nlinks; j++)
          (void) fprintf(fp, "%s%c",  NAMESV(j), (char) 0);
        if (fclose(fp) == EOF)
          (void) fprintf(stderr, "error 4 in writing line color vector\n");
        XtFree((XtPointer) namesv);
      }
    }
  }

  else     /* if not S */
  {
    if (!mono)
    {
      (void) strcpy(fnameplus, fname);
      (void) strcat(fnameplus, ".linecolors");
      if ( (fp = fopen(fnameplus, "w")) == NULL)
      {
        sprintf(message,
          "The file '%s' can't be opened for writing\n", fnameplus);
        show_message(message, xg);
        return;
      }
      else
      {
        for (j=0; j<xg->nlinks; j++)
        {
          for (i=0; i<xg->nlinks; i++)
          {
            if (xg->line_color_now[j] == color_nums[i])
            {
              cid = color_names[i];
              break;
            }
          }
          (void) fprintf(fp, "%s\n", cid);
        }
      }
      if (fclose(fp) == EOF)
        (void) fprintf(stderr, "error in writing line color vector\n");
    }
  }
}

void
reset_rows_in_plot(xg, reset_lims)
  xgobidata *xg;
  Boolean reset_lims;
{
  int j;

  if (xg->is_dotplotting)
    dotplot_texture_var(xg);

  if (xg->ncols_used > 2)
    update_sphered(xg, (int *) NULL, xg->ncols_used);
  if (reset_lims)
    update_lims(xg);
  update_world(xg);
  world_to_plane(xg);
  plane_to_screen(xg);

  if (reset_lims)
  {
    if (xg->is_xyplotting)
    {
      for (j=0; j<xg->ncols_used; j++)
      {
        xg->nicelim[j].min = xg->lim0[j].min;
        xg->nicelim[j].max = xg->lim0[j].max;
        SetNiceRange(j, xg);
        xg->deci[j] = set_deci(xg->tickdelta[j]);
      }
      init_ticks(&xg->xy_vars, xg);
    }
    else if (xg->is_dotplotting)
      init_ticks(&xg->dotplot_vars, xg);
  }

  if (xg->is_pp)
  {
    xg->recalc_max_min = True;
    reset_pp_plot();
    pp_index(xg,0,1);
  }

  if (xg->is_brushing && xg->linked_brushing)
    copy_brushinfo_to_senddata(xg);
}

/* ARGSUSED */
XtCallbackProc
delete_erased_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;

  int i;
  Boolean nerased = False;

  /*
   * First make sure that some points are erased.
  */
  for (i=0; i<xg->nrows; i++)
    if (!xg->erased[i])
    {
      nerased = True;
      break;
    }

  if (nerased)
  {
    xg->nrows_in_plot = 0;
    for (i=0; i<xg->nrows; i++)
      if (!xg->erased[i])
        xg->rows_in_plot[(xg->nrows_in_plot)++] = i;

    xg->delete_erased_pts = True;

    reset_rows_in_plot(xg, True);
    if (xg->linked_brushing)
    {
      XtOwnSelection( (Widget) xg->workspace,
        (Atom) XG_ROWSINPLOT,
        (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
        /*(Time) XtLastTimestampProcessed(display),*/
        (XtConvertSelectionProc) pack_rowsinplot_data,
        (XtLoseSelectionProc) pack_brush_lose ,
        (XtSelectionDoneProc) pack_brush_done );
      announce_rows_in_plot(xg);
    }

    assign_points_to_bins(xg);
    plot_once(xg);
  }
}

/* ARGSUSED */
XtCallbackProc
undelete_erased_cback(w, xgobi, callback_data)
  Widget w;
  XtPointer *xgobi;
  XtPointer callback_data;
{
  xgobidata *xg = (xgobidata *) xgobi;
  int i;

  for (i=0; i<xg->nrows; i++)
    xg->rows_in_plot[i] = i;
  xg->nrows_in_plot = xg->nrows;
  xg->delete_erased_pts = False;

  reset_rows_in_plot(xg, True);
  if (xg->linked_brushing)
  {
    XtOwnSelection( (Widget) xg->workspace,
      (Atom) XG_ROWSINPLOT,
      (Time) CurrentTime, /* doesn't work with XtLastTimeStamp...? */
      /*(Time) XtLastTimestampProcessed(display),*/
      (XtConvertSelectionProc) pack_rowsinplot_data,
      (XtLoseSelectionProc) pack_brush_lose ,
      (XtSelectionDoneProc) pack_brush_done );
    announce_rows_in_plot(xg);
  }

  assign_points_to_bins(xg);
  plot_once(xg);
}

#undef NAMESIZE
#undef NAMESV
#undef SMALL
#undef MEDIUM
#undef LARGE

