
/* Copyright (C) 1992  AHPCRC, Univeristy of Minnesota
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file named 'Copying'; if not, write to
 * the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139.
 */

/* Author:
 *	Ken Chin-Purcell (ken@ahpcrc.umn.edu)
 *	Army High Performance Computing Research Center (AHPCRC)
 *	Univeristy of Minnesota
 *
 * $Header: /usr/people/ken/gvl/lib/RCS/util.h,v 2.2 92/10/19 16:55:44 ken Exp $
 *
 * $Log:	util.h,v $
 * Revision 2.2  92/10/19  16:55:44  ken
 * Trivial change
 * 
 * Revision 1.1  92/10/19  16:37:11  ken
 * Initial revision
 * 
 */

/* Min & Max macros
 */
#define MIN(i,j)  ((i)<(j) ?  (i) : (j))
#define MAX(i,j)  ((i)>(j) ?  (i) : (j))
#define ABS(i)    ((i)< 0  ? -(i) : (i))

/* Memory macros
 */
#define MallocType(type)	(type *) malloc(sizeof(type))
#define CallocType(type,i)	(type *) calloc(i,sizeof(type))
#define ReallocType(ptr,type,i)	(type *) realloc(ptr,(i)*sizeof(type))
#define ZeroType(ptr,type)	(void) memset(ptr, 0, sizeof(type))
#define Free(ptr)		if (ptr) free(ptr)

/* Error checking macros
 * Use MemCheck after allocationg memory.
 */
#define Verify(expr,estr)	if (!(expr)) BailOut(estr,__FILE__,__LINE__)
#define MemCheck(ptr)	if (!(ptr)) BailOut("Out of memory",__FILE__,__LINE__)


/* Prototypes */

/* util.c */
void	Error (char *errstr, ...);
void	SetCoreDump (int dumpit);
void	BailOut (char *errstr, char *fname, int lineno);
int	FindFileSize (char *fname);
unsigned	char *ReadColormap (unsigned char *cmap, char *cmapName);
char	*NewString (char *old, int extra);
void	CommaLong (char *s, long i);
long	ScanLong (char *s);
long	RoundUp (long a, long modulo);
long	Factor (long a);
unsigned	MarkTime (void);
int	ppopen (char **argv, int *pInOut);
