/* Author:
 *	Ken Chin-Purcell (ken@ahpcrc.umn.edu)
 *	Army High Performance Computing Research Center (AHPCRC)
 *	Univeristy of Minnesota
 *
 * $Header: /usr/people/ken/gvl/bob/RCS/bobload.c,v 2.2 92/10/27 16:50:21 ken Exp Locker: ken $
 *
 * $Log:	bobload.c,v $
 * Revision 2.2  92/10/27  16:50:21  ken
 * Added basic point support
 * 
 * Revision 2.1  92/10/19  17:03:35  ken
 * *** empty log message ***
 * 
 * Revision 1.1  92/10/19  17:03:00  ken
 * Initial revision
 * 
 */

#include <unistd.h>
#include <signal.h>
#include <bstring.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/time.h>
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>


/* from util.c */

#include <stdarg.h>
#define Verify(expr,estr)	if (!(expr)) BailOut(estr,__FILE__,__LINE__)

/*VARARGS1*/
void Error(char *errstr, ...)
{
    /* Print a string to standard eror.
     */
    va_list	args;
    
    va_start(args, errstr);
    (void) vfprintf(stderr, errstr, args);
    (void) fflush(stderr);
}


void BailOut(char *errstr, char *fname, int lineno)
{
    /* Terminate program after printing an error message.
     * Use via the macros Verify and MemCheck.
     */
    char	yesno[32];
    
    yesno[0] = 0;
    Error("Error: %s, at %s:%d\n", errstr, fname, lineno);
    exit(1);
}

/* end of util.c */


extern int	select(int, fd_set *, fd_set *, fd_set *, struct timeval *);

unsigned char	*bobData;
int		shmid;

int		dim[3];
unsigned	bobSize;
FILE		*cmdFile;
FILE		*bobFile;
FILE		*pointFile = NULL;


static void Usage(void)
{
    Error("\n");
    Error("usage: bobload XxYxZ cmdFile bobData [ pointData ]\n");
    Error("	XxYxZ		Brick dimension\n");
    Error("	cmdFile		Named pipe for bob commands\n");
    Error("	bobData		Brick of bytes\n");
    Error("	pointData	Array of Points\n");
    Error("\n");
}


static int Setup(int argc, char *argv[])
{
    if (argc < 4) {
	Usage();
	return 0;
    }

    if (sscanf(argv[1], "%dx%dx%d", dim, dim + 1, dim + 2) < 3) {
	Usage();
	return 0;
    }

    cmdFile = fopen(argv[2], "w");
    if (!cmdFile) {
	Error("Cannot open %s for writing\n", argv[2]);
	return 0;
    }

    bobFile = fopen(argv[3], "r");
    if (!bobFile) {
	Error("Cannot open %s for writing\n", argv[3]);
	return 0;
    }

    if (argc >4) {
	pointFile = fopen(argv[3], "r");
	if (!pointFile) {
	    Error("Cannot open %s for writing\n", argv[4]);
	    return 0;
	}
    }
    
    bobSize = dim[0] * dim[1] * dim[2];
    shmid = shmget(IPC_PRIVATE, bobSize, IPC_CREAT|0777);
    Verify(shmid >= 0, "shmget failed");

    bobData = shmat(shmid, 0, 0);
    Verify(bobData != ((unsigned char *) -1), "shmat failed");
    
    return 1;
}


static void ReadBrick(void)
{
    (void) fread(bobData, bobSize, 1, bobFile);
}


static void SendBrick(void)
{
    (void) fprintf(cmdFile, "size = %d %d %d\n", dim[0], dim[1], dim[2]);
    (void) fprintf(cmdFile, "file = /dev/mem/%d\n", shmid);
    (void) fclose(cmdFile);
}


main(int argc, char *argv[])
{
    if (!Setup(argc, argv))
	return 1;
    
    ReadBrick();
    SendBrick();
    (void) shmdt(bobData);

    return 0;
}
