/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		xyscale.c - Program to rescale images with arbitrary x 
*				    and y scalings.
* REVISION:             3.1
* AUTHOR:               PK 
* CREATION DATE:        May 1993
* REVISION DATE:	3/3/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	03 March 1994
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* "@(#)xyscale.c	3.1 3/3/94"
*
*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include "vip.h"
#include "vipiofn.h"
#include "vipspatfn.h"
#include "misc.h"

void main(int argc, char *argv[])
{
IMAGE *outimage, *inimage;
float x_scale, y_scale;

if(argc != 5) {
 VIP_Error_Msg("scale: inimage x_scale, y_scale out_image");
 return;
}

inimage = (IMAGE *)Read_Image(argv[1]);
x_scale = (float)atof(argv[2]);
y_scale = (float)atof(argv[3]);

outimage = (IMAGE *)XYScale_Image(inimage, x_scale, y_scale);

Write_Image(outimage, argv[4]);

Free_Image(inimage);
Free_Image(outimage);

return;
}


