/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		thresh.c - Threshold an image. 
*				   Pixels whose values are higher than a given
*				   threshold are set to 255, or set to 0
*				   otherwise.
* REVISION:             3.1
* AUTHOR:               CA
* CREATION DATE:        11 March 1994
* REVISION DATE:	3/11/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* CREATION DATE:        11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)thresh.c	3.1 3/11/94";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void            Usage();
void            Pperror( char * );
static int      Get_Threshold( struct struct_vip_IMAGE *, int, 
                               int, int, double );


/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: thresh [input_file] [-t|-f|-c thresh] [-o output_file]\n");
    (void) fprintf(stderr, "       -t threshold to binary image (default)\n");
    (void) fprintf(stderr, "       -f (floor) threshold to greyscale image\n");
    (void) fprintf(stderr, "       -c (ceiling) threshold to greyscale image\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "thresh: %s\n", e);
    exit(1);
}


/*- Get_Threshold ---------------------------------------------------

Calculate threshold value.

--------------------------------------------------------------------*/

static int Get_Threshold(im, t, f, c, percent)
IMAGE  *im;
int     t,f,c;
float   percent;
{
    register int rr, cc;
    int     freq[256], thres;
    long    siz, count, cnt = 0;
    unsigned char start_pix, offset, pix;

    if (im)
	return (-1);

    siz = (long) im->rows * (long) im->cols;
    for (rr = 0; rr < 256; rr++)
	freq[rr] = 0;

    switch (im->type) {
    case BYTETYPE:
	/* get pixel value statistics */
	for (rr = 0; rr < im->rows; rr++)
	    for (cc = 0; cc < im->cols; cc++)
		freq[im->i.c[rr][cc]]++;

	count = percent * siz;
	if (c) {
	    start_pix = 255;
	    offset = -1;
	}
	else {
	    start_pix = 0;
	    offset = 1;
	}
	for (pix = start_pix;; pix += offset) {
	    if (cnt >= count) {
		thres = (float) ((int) pix);
		break;
	    }
	    cnt += freq[pix];
	}
	break;
    default:
	VIP_Error_Msg("Get_Threshold: can only process images of BYTETYPE");
	return (-1);
    }
    return (thres);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    register int argn;
    int     t = 0, f = 0, c = 0;
    float   thres = 128.0;
    char   *in_arg = NULL, *out_arg = NULL, str[80];
    IMAGE  *im, *outim;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 't':
		t = 1;
		thres = atof(argv[++argn]);
		break;
	    case 'f':
		f = 1;
		thres = atof(argv[++argn]);
		break;
	    case 'c':
		c = 1;
		thres = atof(argv[++argn]);
		break;
	    case 'o':
		out_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
	else if (!in_arg)
	    in_arg = argv[argn];
	else
	    Usage();

    if (t + f + c > 1)
	Pperror("Only one of the flags -t, -f, and -c can be used");
    if (t + f + c == 0)
	t = 1;			/* default */

    if ((im = ( IMAGE * ) Read_Image(in_arg)) == NULL)
	Pperror("vision system error in Read_Image");

    if (thres < 1.0) {
	/*
	 * assume thres represents the percentage of pixels that that need to
	 * threshold out, so recalculate the actual threshold value.
	 */
	thres = Get_Threshold(im, t, f, c, thres);
	(void) sprintf(str, "threshold calculated = %d", (int) thres);
	VIP_Error_Msg(str);
    }
    if (t)
	outim = ( IMAGE * ) Thresh_Image(im, (int) thres);
    else if (f)
	outim = ( IMAGE * ) Floor_Thresh_Image(im, (int) thres);
    else
	outim = ( IMAGE * ) Ceiling_Thresh_Image(im, (int) thres);

    if (outim) Write_Image(outim, out_arg);

    exit(0);
}
