/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		sumim.c - Pixelwisely sum two images.
* REVISION:             3.1
* AUTHOR:               CA
* CREATION DATE:        27 May 1987
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	24 Jan 1992 
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)sumim.c	3.1 7/10/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void            Usage();
void            Pperror( char * );
IMAGE           *Sum_Image( struct struct_vip_IMAGE *, struct struct_vip_IMAGE * );


/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) (void) fprintf(stderr, "usage: sumim [image_1] [image_2] [-o sum_image]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) (void) fprintf(stderr, "sumim: %s\n", e);
    exit(1);
}


/*- Sum_Image -------------------------------------------------------

Return the sum of two images.

--------------------------------------------------------------------*/

IMAGE  *Sum_Image(im1, im2)
IMAGE  *im1, *im2;
{
    register int r, c, i;
    IMAGE  *outim;

    if (!im1 || !im2) {
	VIP_Error_Msg("Sum_Image: input images are NULL");
	return (NULL);
    }
    else if ((im1->rows != im2->rows) || (im1->cols != im2->cols)) {
	VIP_Error_Msg("Sum_Image: input images have inconsistent dimensions");
	return (NULL);
    }
    else if (im1->type != im2->type) {
	VIP_Error_Msg("Sum_Image: input images are not of the same type");
	return (NULL);
    }

    if (!(outim = ( IMAGE * ) Allocate_Image(0, 0, im1->rows, im1->cols, im1->type))) {
	VIP_Error_Msg("Sum_Image: out of memory");
	return (NULL);
    }

    Copy_Header(im1, outim);

    switch (im1->type) {
    case BYTETYPE:
	for (r = im1->rows - 1; r >= 0; r--)
	    for (c = im1->cols - 1; c >= 0; c--)
		outim->i.c[r][c] = im1->i.c[r][c] + im2->i.c[r][c];
	break;
    case SHORTTYPE:
	for (r = im1->rows - 1; r >= 0; r--)
	    for (c = im1->cols - 1; c >= 0; c--)
		outim->i.s[r][c] = im1->i.s[r][c] + im2->i.s[r][c];
	break;
    case LONGTYPE:
	for (r = im1->rows - 1; r >= 0; r--)
	    for (c = im1->cols - 1; c >= 0; c--)
		outim->i.l[r][c] = im1->i.l[r][c] + im2->i.l[r][c];
	break;
    case FLOATTYPE:
	for (r = im1->rows - 1; r >= 0; r--)
	    for (c = im1->cols - 1; c >= 0; c--)
		outim->i.f[r][c] = im1->i.f[r][c] + im2->i.f[r][c];
	break;
    case DOUBLETYPE:
	for (r = im1->rows - 1; r >= 0; r--)
	    for (c = im1->cols - 1; c >= 0; c--)
		outim->i.d[r][c] = im1->i.d[r][c] + im2->i.d[r][c];
	break;
    case COMPLEXTYPE:
	for (r = im1->rows - 1; r >= 0; r--)
	    for (c = im1->cols - 1; c >= 0; c--) {
		outim->i.cx[r][c].r = im1->i.cx[r][c].r + im2->i.cx[r][c].r;
		outim->i.cx[r][c].i = im1->i.cx[r][c].i + im2->i.cx[r][c].i;
	    }
	break;
    case RGBTYPE:
	for (r = im1->rows - 1; r >= 0; r--)
	    for (c = im1->cols - 1; c >= 0; c--)
		for (i = 3; i >= 0; i--)
		    outim->i.rgb[r][c][i] = im1->i.rgb[r][c][i] + im2->i.rgb[r][c][i];
	break;
    case HSITYPE:
	for (r = im1->rows - 1; r >= 0; r--)
	    for (c = im1->cols - 1; c >= 0; c--)
		for (i = 3; i >= 0; i--)
		    outim->i.hsi[r][c][i] = im1->i.hsi[r][c][i] + im2->i.hsi[r][c][i];
	break;
    default:
	VIP_Error_Msg("Sum_Image: unknown image type");
	Free_Image(outim);
	outim = NULL;
    }

    return (outim);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *arg1 = NULL, *arg2 = NULL, *out_arg = NULL;
    IMAGE  *im1, *im2, *outim;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		out_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
	else if (!arg1)
	    arg1 = argv[argn];
	else if (!arg2)
	    arg2 = argv[argn];
	else
	    Usage();

    if (!(im1 = ( IMAGE *  ) Read_Image(arg1)))
	Pperror("vision system error in Read_Image(arg1)");
    if (!(im2 = ( IMAGE * ) Read_Image(arg2)))
	Pperror("vision system error in read_matrix(arg2)");

    if (!(outim = ( IMAGE * ) Sum_Image(im1, im2)))
	Pperror("error return from Sum_Image");

    Write_Image(outim, out_arg);

    exit(0);
}
