/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		spy.c - Dump an image data file. The code is imported
*			        from an older version of V.I.P. 
* REVISION:             3.1
* AUTHOR:		CA/DH               
* CREATION DATE:        08 Oct 1991
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	08 Oct 1991
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)spy.c	3.1 7/10/92";
#endif



#include <stdio.h>
#include <stdlib.h>
#include "vip.h"

void            Usage();
void            Pperror( char * );
void            Dump_Image( struct struct_vip_IMAGE *, int, int, int );


/*- Usage -----------------------------------------------------------

Print usage message and error exit the program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "Usage: spy [file] [-p] [-i initial_row] [-f final_row]\n");
    exit(1);
}



/*- Dump_Image ------------------------------------------------------

Dump an image file, starting from row "init" to row "final",
as text format to stdout.

--------------------------------------------------------------------*/

void Dump_Image(im, init, final, precision)
IMAGE  *im;
int     init, final, precision;
{
    register int r, c;

    switch (im->type) {
    case BYTETYPE:
	for (r = init; r <= final; r++) {
	    (void) printf("%d:", r);
	    for (c = 0; c < im->cols; c++) {
		if (c % 10 == 0)
		    putchar('\n');
		if (precision)
		    (void) printf("%7d %7d\n", c, im->i.c[r][c]);
		else
		    (void) printf("%7d", im->i.c[r][c]);
	    }
	    putchar('\n');
	}
	break;
    case SHORTTYPE:
	for (r = init; r <= final; r++) {
	    (void) printf("%d:", r);
	    for (c = 0; c < im->cols; c++) {
		if (c % 10 == 0)
		    putchar('\n');
		if (precision)
		    (void) printf("%7d %7d\n", c, im->i.s[r][c]);
		else
		    (void) printf("%7d", im->i.s[r][c]);
	    }
	    putchar('\n');
	}
	break;
    case LONGTYPE:
	for (r = init; r <= final; r++) {
	    (void) printf("%d:", r);
	    for (c = 0; c < im->cols; c++) {
		if (c % 10 == 0)
		    putchar('\n');
		if (precision)
		    (void) printf("%7ld %7ld\n", c, im->i.l[r][c]);
		else
		    (void) printf("%7ld", im->i.l[r][c]);
	    }
	    putchar('\n');
	}
	break;
    case FLOATTYPE:
	for (r = init; r <= final; r++) {
	    (void) printf("%d:", r);
	    for (c = 0; c < im->cols; c++) {
		if (c % 10 == 0)
		    putchar('\n');
		if (precision)
		    (void) printf("%7d %.25f\n", c, im->i.f[r][c]);
		else
		    (void) printf("%6.3f ", im->i.f[r][c]);
	    }
	    putchar('\n');
	}
	break;
    case DOUBLETYPE:
	for (r = init; r <= final; r++) {
	    (void) printf("%d:", r);
	    for (c = 0; c < im->cols; c++) {
		if (c % 10 == 0)
		    putchar('\n');
		if (precision)
		    (void) printf("%7d %.25lf\n", c, im->i.d[r][c]);
		else
		    (void) printf("%6.3lf ", im->i.d[r][c]);
	    }
	    putchar('\n');
	}
	break;
    case COMPLEXTYPE:
	for (r = init; r <= final; r++) {
	    (void) printf("%d:", r);
	    for (c = 0; c < im->cols; c++) {
		if (c % 5 == 0)
		    putchar('\n');
		if (precision)
		    (void) printf("%7d (%.25f,%.25f)\n", c, im->i.cx[r][c].r, im->i.cx[r][c].i);
		else
		    (void) printf("(%6.3f,%6.3f) ", im->i.cx[r][c].r, im->i.cx[r][c].i);
	    }
	    putchar('\n');
	}

	break;
    case RGBTYPE:
	for (r = init; r <= final; r++) {
	    (void) printf("%d:", r);
	    for (c = 0; c < im->cols; c++) {
		if (c % 5 == 0)
		    putchar('\n');
		if (precision)
		    (void) printf("%7d (%7d,%7d,%7d)\n", c,
			   im->i.rgb[r][c][0],
			   im->i.rgb[r][c][1],
			   im->i.rgb[r][c][2]);
		else
		    (void) printf("(%3d,%3d,%3d) ", im->i.rgb[r][c][0],
			   im->i.rgb[r][c][1], im->i.rgb[r][c][2]);
	    }
	    putchar('\n');
	}

	break;
    case HSITYPE:
	for (r = init; r <= final; r++) {
	    (void) printf("%d:", r);
	    for (c = 0; c < im->cols; c++) {
		if (c % 5 == 0)
		    putchar('\n');
		if (precision)
		    (void) printf("%7d (%7d,%7d,%7d)\n", c,
			   im->i.hsi[r][c][0],
			   im->i.hsi[r][c][1],
			   im->i.hsi[r][c][2]);
		else
		    (void) printf("(%3d,%3d,%3d) ", im->i.hsi[r][c][0],
			   im->i.hsi[r][c][1], im->i.hsi[r][c][2]);
	    }
	    putchar('\n');
	}

	break;
    default:
	VIP_Error_Msg("Dump_Image: invalid image type");
	exit(1);
    }
}


/*- Main program ----------------------------------------------------

Spy dump an image file as text format to stdout.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *file_arg = NULL;
    int     init_arg = 0, final_arg = -1, precision_arg = 0;
    IMAGE  *im = NULL;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'i':
		if (++argn < argc)
		    init_arg = atoi(argv[argn]);
		else
		    Usage();
		break;
	    case 'f':
		if (++argn < argc)
		    final_arg = atoi(argv[argn]);
		else
		    Usage();
		break;
	    case 'p':
		precision_arg = argn;
		break;
	    default:
		Usage();
	    }
	else if (!file_arg)
	    file_arg = argv[argn];
	else
	    Usage();


    if (!(im = ( IMAGE * ) Read_Image(file_arg)))
	exit(1);

    if (final_arg == -1)
	final_arg = im->rows - 1;
    Dump_Image(im, init_arg, final_arg, precision_arg);
    exit(0);
}


/*-------------------------------------------------------------------------*/
