/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		logim.c - Return the logarithmic transformation
*				  of a given image.
* REVISION:             3.2
* AUTHOR:		DH               
* CREATION DATE:	23 Sep 1988        
* REVISION DATE:	4/8/94        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.2
* REVISION DATE:	8 April 1994
* COMMENT:		Fixed compiler warnings
* BY:			BJR
*
* REVISION:		3.1
* REVISION DATE:	16 March 1994
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	17 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)logim.c	3.2 4/8/94";
#endif




#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void            Usage();
void            Pperror( char * );


/*- Usage  ----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: logim [input_file] [-o output_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "logim: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

int main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *input_arg = NULL;
    char   *output_arg = NULL;
    IMAGE  *inm, *outm;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc) output_arg = argv[argn];
		else Usage();
		break;
	    default:
		Usage();
	    }
	else if (!input_arg)
	    input_arg = argv[argn];
	else
	    Usage();


    if (!(inm = ( IMAGE * ) Read_Image(input_arg)))
	Pperror("vision system error in Read_Image");

    if ( (outm = ( IMAGE * )  Logarithmic_Transform_Image(inm)) )
	Write_Image(outm, output_arg);
    else
	Pperror("vision system error in new_matrix");

    exit(0);
}
