/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		gnoise.c - Add Gaussian Noise to image. The method
*				   used to generate samples from the normal
*				   distribution, is the one outlined in
*				   algorithm #267 of the ACM. (based on the
*				   Box&Muller method for generating pairs of
*				   normal deviates).
* REVISION:             3.1
* AUTHOR:               CA
* CREATION DATE:        19 Nov 1991
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	29 July 1987
* COMMENT:		modified from an older version of V.I.P.
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)gnoise.c	3.1 7/10/92";
#endif




#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void            Usage();
void            Pperror( char * );


#define TWO_PI      6.283185307179586

#ifdef DOS
#define MAX         32768.0
#else
#define MAX         2147483648.0
#endif

/*
extern double atof();
*/

/*- Usage -----------------------------------------------------------

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: gnoise [image_file] [-s std_dev] [-S seed] [-o out_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

--------------------------------------------------------------------*/

void pperror(e)
char   *e;
{
    (void) fprintf(stderr, "gnoise: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn, seed = 1;
    char   *image_arg = NULL;
    char   *noise_arg = NULL;
    IMAGE  *im;
    double  sd = 30;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'S':
		seed = atoi(argv[++argn]);
		break;
	    case 's':
		sd = atof(argv[++argn]);
		break;
	    case 'o':
		noise_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
	else if (!image_arg)
	    image_arg = argv[argn];
	else
	    Usage();


    if (sd < 0)
	pperror("Standard Deviation must be > 0");

    if (!(im = ( IMAGE * ) Read_Image(image_arg)))
	exit(1);

    srand(( unsigned int ) seed);
    Gnoise(im, sd);

    Write_Image(im, noise_arg);

    exit(0);
}


/*-------------------------------------------------------------------------*/
