/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		gaussian.c - Create a Gaussian mask.
* REVISION:             3.1
* AUTHOR:               CA/IR/DH
* CREATION DATE:        14 March 1994
* REVISION DATE:	3/14/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	14 March 1994
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	17 Jan 1992
* COMMENT:		NEWVIP
* BY:			DH
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)gaussian.c	3.1 3/14/94";
#endif



#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void            Usage();
void            Pperror( char * );



#define TWO_ROOT2   2.828427124
#ifndef PI
#define PI          3.141592654
#endif
#define SQRT_2PI    2.506628274


/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: gaussian omega [-m] [-o out_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "gaussian: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    char   *mask_arg = NULL;
    int     argn, omega = 0, two_dim_arg = 0;
    IMAGE  *f;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'm':
		two_dim_arg = argn;
		break;
	    case 'o':
		mask_arg = argv[++argn];
		break;
	    default:
		Usage();
	    }
	else if (!omega)
	    omega = atoi(argv[argn]);
	else
	    Usage();


    if (!omega)
	Usage();

    if (two_dim_arg)
	f = ( IMAGE * ) Gaussian_2D(omega);
    else
	f = ( IMAGE * ) Gaussian_1D(omega);

    if (!f) {
	VIP_Error_Msg("vision system error in the Gaussian function.");
	exit(1);
    }

    Write_Image(f, mask_arg);
}
