/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		deres.c 		
* REVISION:             3.1
* AUTHOR:               CA/DH
* CREATION DATE:        1 Dec 1986
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:		
* REVISION DATE:	24 Oct 1990
* COMMENT:		Deresolve image
* BY:
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)deres.c	3.1 7/10/92";
#endif


#include <stdio.h>
#include <stdlib.h>
#include "vip.h"


void                            Usage();
void                            pperror( char * );
struct  struct_vip_IMAGE        *deres_image( struct struct_vip_IMAGE *, int );
struct  struct_vip_IMAGE        *deres_image2( struct  struct_vip_IMAGE *, int );


/*-------------------------------------------------------------------------*/


void usage()
{
    (void) fprintf(stderr,
	    "usage: deres [filename] [-r resolution] [-s] [-o out_file]\n");
    (void) fprintf(stderr, "-s select pixels directly from image and do not perform averaging\n");
    exit(1);
}


/*-------------------------------------------------------------------------*/


void pperror(e)
char   *e;
{
    (void) fprintf(stderr, "deres: %s\n", e);
    exit(1);
}


/*-------------------------------------------------------------------------*/


IMAGE  *deres_image(im, deres)
IMAGE  *im;
int     deres;
{
    register int r, c;
    int     deres2, nr, nc;
    int     lr, lc, sr, sc;
    IMAGE  *de;
    long    tin;

    deres2 = deres * deres;
    nr = im->rows / deres;
    nc = im->cols / deres;
    if (!(de = ( IMAGE * ) Allocate_Image(im->umin, im->vmin, nr, nc, BYTETYPE)))
	pperror("vision system error no memory");
    de->resolution = deres;

    for (r = 0; r < nr; r++)
	for (c = 0; c < nc; c++) {
	    sr = r * deres;
	    sc = c * deres;
	    tin = 0;
	    for (lr = 0; lr < deres; lr++)
		for (lc = 0; lc < deres; lc++)
		    tin += im->i.c[sr + lr][sc + lc];
	    de->i.c[r][c] = tin / deres2;
	}

    return (de);
}


/*-------------------------------------------------------------------------*/


IMAGE  *deres_image2(im, deres)
IMAGE  *im;
int     deres;

/* simply pick the pixels separating by "deres" pixels and do not do
   averaging. */
{
    register int r, c, rr, cc;
    int     nr, nc;
    IMAGE  *deresim;

    nr = im->rows / deres;
    nc = im->cols / deres;
    if (!(deresim = ( IMAGE * ) Allocate_Image(im->umin, im->vmin, nr, nc, BYTETYPE)))
	pperror("deres_image2: Fail to allocate space for new image");
    for (r = rr = 0; r < nr; r++, rr += deres)
	for (c = cc = 0; c < nc; c++, cc += deres)
	    deresim->i.c[r][c] = im->i.c[rr][cc];
    return deresim;
}

/*-------------------------------------------------------------------------*/


main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *file_arg = NULL;
    char   *deres_arg = NULL;
    IMAGE  *im, *dim;
    int     deres = 2, select = 0;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 's':
		select = 1;
		break;
	    case 'r':
		deres = atoi(argv[++argn]);
		break;
	    case 'o':
		deres_arg = argv[++argn];
		break;
	    default:
		usage();
	    }
	else if (!file_arg)
	    file_arg = argv[argn];
	else
	    usage();


    if (deres < 2)
	pperror("resolution factor must be > 1");

    if (!(im = ( IMAGE * ) Read_Image(file_arg)))
	pperror("vision system error in read_image");
    if (select)
	dim = ( IMAGE * ) deres_image2(im, deres);
    else
	dim = ( IMAGE * ) deres_image(im, deres);

    Write_Image(dim, deres_arg);


    exit(0);
}


/*-------------------------------------------------------------------------*/
