/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		cx2ri.c -      Split a complex image into two images
*				       of FLOATTYPE; the real and exponential
*				       parts.
* REVISION:             3.1
* AUTHOR:		DH               
* CREATION DATE:        11 March 1994
* REVISION DATE:	3/16/94	     
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 March 1994
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)cx2ri.c	3.1 3/16/94";
#endif

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "vip.h"
#include "misc.h"

void Usage();
void Pperror(char *e);
IMAGE	*Sever_Image(IMAGE *cim, IMAGE *mat, int imtype);

/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: cx2ri [-R real_file] [-I imag_file] [input_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "cx2ri: %s\n", e);
    exit(1);
}


/*- Sever_Image -----------------------------------------------------

Perform the splitting.

--------------------------------------------------------------------*/

IMAGE	*Sever_Image(cim, mat, imtype)
IMAGE  *cim;
IMAGE  *mat;
int    imtype;
{
    int     rr, cc;

    if (!(mat = ( IMAGE * ) Allocate_Image(0, 0, cim->rows, cim->cols, FLOATTYPE))) {
	VIP_Error_Msg("Sever: out of memory");
	return (ERROR);
    }

    Copy_Header(cim, mat);
    mat->type = FLOATTYPE;
    for (rr = cim->rows-1; rr >= 0; rr--)
	for (cc = cim->cols-1; cc >= 0; cc--) {
            if (imtype == 0) {
	        mat->i.f[rr][cc] = cim->i.cx[rr][cc].r;
	    }
	    else {
	        mat->i.f[rr][cc] = cim->i.cx[rr][cc].i;
	    }
	}
    return (mat);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *real_arg = NULL;	/* filename for the real part */
    char   *in_arg = NULL;	/* filename for the complex image */
    char   *imag_arg = NULL;	/* filename for the imag. part */
    IMAGE  *im;
    IMAGE  *tmpim;
    IMAGE  *rim, *iim;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'I':
		if (++argn < argc)
		    imag_arg = argv[argn];
		break;
	    case 'R':
		if (++argn < argc)
		    real_arg = argv[argn];
		break;
	    default:
		Usage();
	    }
	else if (!in_arg)	/* input complex filename */
	    in_arg = argv[argn];
	else
	    Usage();

    if (!(im = ( IMAGE * ) Read_Image(in_arg)))
	Pperror("error return from Read_Image");

    if (tmpim = Sever_Image(im, rim, 0)) {
	if (!Write_Image(tmpim, real_arg))
	    VIP_Error_Msg("vision system error in Write_Image when writing real image");
    }

    Free_Image(tmpim);

    if (tmpim = Sever_Image(im, iim, 1)) {
	if (!Write_Image(tmpim, imag_arg))
	    VIP_Error_Msg("vision system error in Write_Image when writing imaginary image");
    }

    exit(0);
}
