/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		convert2byte.c - Convert an image to BYTETYPE.
* REVISION:             3.1
* AUTHOR:               CF
* CREATION DATE:        11 March 1994
* REVISION DATE:	3/11/94
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* CREATION DATE:        11 March 1994
* COMMENT:		ANSIfied and SCCS'd 
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)convert2byte.c	3.1 3/11/94";
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"
#include "vipiofn.h"

void Usage();
void Pperror(char *e);

/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: convert2byte [in_image] [-o out_image]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "convert2byte: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *image_arg = NULL;
    char   *out_arg = NULL;
    IMAGE  *im = NULL, *outim = NULL;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc)
		    out_arg = argv[argn];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!image_arg)
	    image_arg = argv[argn];
	else
	    Usage();

    if (!(im = ( IMAGE * ) Read_Image(image_arg)))
	Pperror("Error return in Read_Image");

    outim = ( IMAGE * ) Convert2Byte_Image(im);
    if (outim)
        Write_Image(outim, out_arg);

    Free_Image(im);
    Free_Image(outim);

    exit(0);
}

