/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		calibrate.c - Program for camera calibration.		
* REVISION:             3.1
* AUTHOR:               PK
* CREATION DATE:        January 1992
* REVISION DATE:	7/14/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)calibrate.c	3.1 7/14/92";
#endif



#include <stdio.h>
#include <stdlib.h>
#include "vip.h"
#include "misc.h"


#define NPTS 50			/* Maximum number of calibration points */


main(argc, argv)
 int      argc;
 char    *argv[];
{
    double   CalibPts[NPTS][3];
    double   ImagePts[NPTS][2];
    int      npts, npts3D;
    CAMERA   camera;
    char     message[80], filename[40], response[20];
    int      lenscomp;


    (void) printf("Enter name of data file containing 3D calibration point data ");
    (void) scanf("%s", filename);
    Read_Calib_Pts(filename, CalibPts, &npts3D);

    (void) printf("\nDo you want to use image calibration point data from a camera calibration file? ");
    (void) scanf("%s", response);

    if (toupper(response[0]) == 'Y') {
	(void) printf("Enter name of camera calibration file containing 2D image point data  ");
	(void) scanf("%s", filename);
	Read_Image_Pts_From_Calib_File(filename, ImagePts, &npts);
    } else {
	(void) printf("\nEnter name of data file containing 2D image calibration point data  ");
	(void) scanf("%s", filename);
	Read_Image_Pts(filename, ImagePts, &npts);
    }


    (void) printf("\n%d 3D points read\n\n", npts3D);
    Print_Matrix_d(&CalibPts[0][0], npts3D, 3);

    (void) printf("\n%d image points read\n\n", npts);
    Print_Matrix_d(&ImagePts[0][0], npts, 2);

    if (npts != npts3D) {
	(void) sprintf(message, "Calibrate: Missmatch - %d 3D points but %d image points",
		npts3D, npts);
	VIP_Error_Msg(message);
	return;
    }
    (void) printf("\nEnter name of output data file  ");
    (void) scanf("%s", filename);
    (void) printf("A binary file of the CAMERA structure will be written to %s\n", filename);
    (void) printf("A text file of calibration data plus an accuracy report \n");
    (void) printf("will be written to %s.txt\n\n", filename);

    (void) printf("\nDo you want lens distortion correction parameters calculated? \n");
    (void) printf("Note: Do NOT use this option if the calibration data is not spread\n");
    (void) printf("widely over the image.  ");
    (void) scanf("%s", response);
    if (toupper(response[0]) == 'Y')
	lenscomp = TRUE;
    else
	lenscomp = FALSE;

    Calibrate(ImagePts, CalibPts, npts, &camera, filename, lenscomp);

    return;
}
