/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            VIP
* MODULE:		byte2complex.c - Convert a image from BYTETYPE to
*					 COMPEXTYPE.
* REVISION:             3.1
* AUTHOR:               PK
* CREATION DATE:        10 March 1992
* REVISION DATE:	7/10/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:		3.1
* REVISION DATE:	11 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
*******************************************************************************/

#ifndef lint
static char *sccs_id = "@(#)byte2complex.c	3.1 7/10/92";
#endif




#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "vip.h"

void Usage();
void Pperror(char *e);


/*- Usage -----------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Usage()
{
    (void) fprintf(stderr, "usage: byte2complex [image_file] [-o compex_image_file]\n");
    exit(1);
}


/*- Pperror ---------------------------------------------------------

Print error message and exit program.

--------------------------------------------------------------------*/

void Pperror(e)
char   *e;
{
    (void) fprintf(stderr, "byte2complex: %s\n", e);
    exit(1);
}


/*- Main ------------------------------------------------------------

Main body of the program.

--------------------------------------------------------------------*/

main(argc, argv)
int     argc;
char   *argv[];
{
    int     argn;
    char   *image_arg = NULL;
    char   *complex_arg = NULL;
    IMAGE  *im, *cxim;

    for (argn = 1; argn < argc; argn++)
	if (argv[argn][0] == '-')
	    switch (argv[argn][1]) {
	    case 'o':
		if (++argn < argc)
		    complex_arg = argv[argn];
		else
		    Usage();
		break;
	    default:
		Usage();
	    }
	else if (!image_arg)
	    image_arg = argv[argn];
	else
	    Usage();

    if (!(im = ( IMAGE * ) Read_Image(image_arg)))
	Pperror("Error return in Read_Image");

    if (!(cxim = ( IMAGE * ) Byte2Complex_Image(im)))
	Pperror("Error return in Byte2Complex_Image");

    Write_Image(cxim, complex_arg);

    exit(0);
}
