/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            INCLUDE
* MODULE:		vip.h -	Header file for V.I.P. images.
* REVISION:             3.6
* AUTHOR:               PK
* CREATION DATE:        7 Mar 1988
* REVISION DATE:	3/18/94  
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:             3.6
* REVISION DATE:	18 March 1994
* COMMENT:		Added decl's etc., for PK's binotrans stuff and include files
* BY:			CFF
*
* REVISION:             3.5
* REVISION DATE:	15 Sept 1993
* COMMENT:		Fixed up GENERIC build.
* BY:			CFF
*
* REVISION:             3.4
* REVISION DATE:	15 August 1993
* COMMENT:		Fixed up DEC build.
* BY:			CFF
*
* REVISION:             3.3
* REVISION DATE:	10 July 1993
* COMMENT:		Fixed up DOS build.
* BY:			CFF
*
* REVISION:             3.2
* REVISION DATE:	8 July 1993
* COMMENT:		added #ifndef __vip_h etc.
* BY:			CFF
*
* REVISION:             3.1
* REVISION DATE:	10 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* REVISION:             
* REVISION DATE:	04 Feb 1992	
* COMMENT:		
* BY:			DH
*
* REVISION:             
* REVISION DATE:	Sept 1991
* COMMENT:		
* BY:			Sam/DH
*
* @(#)vip.h	"@(#)vip.h	3.6 3/18/94"
*
*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>




/* Stuff for platform independence ..... */

#ifdef SUN
#define 	B_ENDIAN
#define 	WORDSIZE	4
#define		int16		short
#define		int32		int
#define		int64		double
#ifndef		U_NIX
#define		U_NIX
#endif
#endif

#ifdef DEC_ALPHA
#define 	L_ENDIAN
#define 	WORDSIZE	8
#define		int16		short
#define		int32		int
#define		int64		long
#ifndef		U_NIX
#define		U_NIX
#endif
#endif

#ifdef LINUX
#define 	L_ENDIAN
#define 	WORDSIZE	4
#define		int16		short
#define		int32		int
#define		int64		double
#ifndef		U_NIX
#define		U_NIX
#endif
#endif

#ifdef DOS
#define 	L_ENDIAN
#define 	WORDSIZE	2
#define		int16		short
#define		int32		long
#define		int64		double
#endif






#if defined(DOS) || defined (LINUX)
#define nint (int32)
#endif

#define VIP_MAJOR_VERSION 4		/* Software version No for file */
#define VIP_MINOR_VERSION 0		/* stamping */

#define VIP_START_SENTINEL 2468
#define VIP_END_SENTINEL   42

#define VIP_MESSAGE_LENGTH 256

#define FILEPLANEMIN 1
#define FILEPLANEMAX 39
#define USERPLANEMIN 40
#define USERPLANEMAX 50

#define PLANEDATAFILE "plane.list"

#define UVOFFSET 256
#define UNCALIBRATED 0
#define MATRIX_ONLY  1
#define MATRIX_PLUS_3POLY 2

/*- ID codes for data structures -------------------------------------*/

#define IMAGE_ID   9191
#define CAMERA_ID  2000
#define INT_MASK_ID   3000
#define PIPSTATUS_ID 4000

/*- Macros  --------------------------------------------------------*/

/* Macro to return the intensity of a point in a BYTE image with *absolute coords u and v */

#define PIXEL_B(image,u,v) (int)(image->i.c[(v)-image->vmin][(u)-image->umin])

/*-  Data types used to build IMAGE structure  ---------------------*/

#if (WORDSIZE == 2)
#define BYTETYPE  1L
#define SHORTTYPE 2L
#define LONGTYPE  3L
#define FLOATTYPE 4L
#define DOUBLETYPE 5L
#define COMPLEXTYPE 6L
#define RGBTYPE     7L
#define HSITYPE     8L
#else
#define BYTETYPE    1
#define SHORTTYPE   2
#define LONGTYPE    3
#define FLOATTYPE   4
#define DOUBLETYPE  5
#define COMPLEXTYPE 6
#define RGBTYPE     7
#define HSITYPE     8
#endif

/*- Data structures  -----------------------------------------------*/

typedef struct struct_vip_COMPLEX {		/* complex number */
    float   r;
    float   i;
}       COMPLEX;


typedef unsigned char RGB[4];	/* Red, Green Blue stored in an array
				 * of four bytes for convenience and
				 * efficiency */
typedef unsigned char HSI[4];

typedef unsigned char *c_array;
typedef int16 *s_array;
typedef int32 *l_array;
typedef float *f_array;
typedef double *d_array;
typedef COMPLEX *cx_array;
typedef RGB *rgb_array;
typedef HSI *hsi_array;

typedef union anytype {
    char    c;
    int16   s;
    int32   l;
    float   f;
    double  d;
    COMPLEX cx;
    RGB     rgb;
    HSI     hsi;
}       anytype;

typedef union imagedata {
    c_array *c;
    s_array *s;
    l_array *l;
    f_array *f;
    d_array *d;
    cx_array *cx;
    rgb_array *rgb;
    hsi_array *hsi;
}       imagedata;

#define  GRAPH_MAX  ((int32)32)

struct GRAPH {
    int32     row;
    int32     nfiles;
    char   *label[GRAPH_MAX];
    char   *filename[GRAPH_MAX];
}       graph[GRAPH_MAX];



/*-  CAMERA structure  --------------------------------------------*/

typedef struct struct_vip_CAMERA {
    int32     idcode;
    char    version[8];
    int32     channel;		/* Channel on PIP board */
    int32     gain, offset;	/* Gain and offset for the channel */
    int32     uvoffset;		/* UV offset in using calibration
				 * matrix and compensation data */
    int32     calib_status;	/* type of calibration data available */
    double  gamma[5];		/* For grey scale correction if
				 * needed */
    double  calib_matrix[3][4];	/* Calibration matrix */
    double  Ucomp[18];		/* Coeffs of lens compensation
				 * polynomial */
    double  Vcomp[18];		/* Coeffs of lens compensation
				 * polynomial */
}       CAMERA;


/*- IMAGE Data Structure --------------------------------------------*/

typedef struct struct_vip_IMAGE {
    int32     idcode;		/* Code to allow automatic
				 * identification */
    int32     version[2];	/* software version No */
    int32     type;		/* Data type - char, rgb colour etc */
    int32     umin;		/* Image origin coords */
    int32     vmin;
    int32     rows;
    int32     cols;
    double  resolution;
    char    info[80];		/* Space for comments */
    struct  struct_vip_CAMERA  camera;
    int32     reserved[3];
    void   *pntr[2];
    union imagedata i;
}       IMAGE;

/*-  SENSOR Structure ------------------------------------------------*/

typedef struct struct_vip_SENSOR {
    double  matrix[4][3];	/* The matrix that does the
				 * conversion */
    struct  struct_vip_CAMERA  camera;		/* Camera data for uvoffset and lens
				 * distortion data */
}       SENSOR;


/*--------------------------------------------------------------------*/


typedef struct struct_vip_INT_MASK {
    int32     idcode;
    char    version[8];
    int32     rows;
    int32     cols;
    int32     rescale;
    l_array *m;			/* mask data */
}       INT_MASK;

/*- Global variables  ----------------------------------------------
 * Global variables are declared in ../lib/vipglobals.c with the
 * macro VIP_GLOBAL defined, the following will do the job automatically.
 */


#ifdef VIP_GLOBAL
/* *** Global variables *** */
FILE   *VIP_STD_ERR = stderr;
FILE   *VIP_LOG_FILE = NULL;
char    VIP_MESSAGE[VIP_MESSAGE_LENGTH];	/* Global message string
						 * for use by X view
						 * alert boxes */


double  PLANE[USERPLANEMAX][3][3];	/* Fifty constraint planes,
					 * each defined by three
					 * points */

int     VIP_LOG = 0;		/* flag to turn data logging on or
				 * off */
int     VIP_VERBOSE = 0;	/* flag to turn on or off extra
				 * printing of data */
int     VIP_DISPLAY = 0;	/* flag to turn image display on or
				 * off */

#else

/* *** External variables **** */
extern FILE *VIP_STD_ERR;
extern FILE *VIP_LOG_FILE;
extern int VIP_LOG;		/* flag to turn data logging on or
				 * off */
extern int VIP_VERBOSE;		/* flag to turn on or off extra
				 * printing of data */
extern char VIP_MESSAGE[VIP_MESSAGE_LENGTH];	/* Global message string
						 * for use by X view
						 * alert boxes */
extern int VIP_DISPLAY;		/* flag for turning image display on
				 * or off */
extern double PLANE[USERPLANEMAX][3][3];	/* Fifty constraint
						 * planes, each defined
						 * by three points */

#endif


/*
  	Declarations for PK binotrans stuff
*/

#define FLOAT_MASK_ID 1
#define NOT_SYMMETRIC 0
#define SYMMETRIC 1
#define ANTI_SYMMETRIC -1



typedef struct struct_vip_FLOAT_MASK {
    int     idcode;
    char    version[8];
    int     rows;
    int     cols;
    int     xsymmetry;
    int     ysymmetry;
    f_array *m;			/* mask data */
}       FLOAT_MASK;


#ifndef __vip_h

/* include the following headers to make life easier for applications programmers ..... */

#include "vip1Dfn.h"
#include "vipcalibfn.h"
#include "vipcomplexfn.h" 
#include "vipfreqfn.h" 
#include "vipglobalsfn.h" 
#include "vipiofn.h" 
#include "vipspatfn.h" 
#include "vectorfn.h" 
#include "miscfn.h" 

#define __vip_h
#endif  /* !__vip_h */

