/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            INCLUDE
* MODULE:		vectorfn.h - ANSI Fn. Prototypes for vector.c
* REVISION:             3.4
* AUTHOR:               CFF
* CREATION DATE:        10 July 1992
* REVISION DATE:	3/18/94        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:             3.4
* CREATION DATE:	18 March 1994
* COMMENT:		Added __vip_h
* BY:			CFF
*
* REVISION:             3.3
* CREATION DATE:	15 Sept 1993        
* COMMENT:		Fixed up for GENERIC build
* BY:			CFF
*
* REVISION:             3.2
* CREATION DATE:	16 August 1993        
* COMMENT:		Fixed up for DEC build
* BY:			CFF
*
* REVISION:             3.1
* CREATION DATE:        10 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* @(#)vectorfn.h	3.4 3/18/94
*
*******************************************************************************/


#ifndef __vip_h
int     Max_i(int *, int, int *);
long    Max_l(long *, int, int *);
float   Max_f(float *, int, int *);
double  Max_d(double *, int, int *);

int     Min_i(int *, int, int *);
long    Min_l(long *, int, int *);
float   Min_f(float *, int, int *);
double  Min_d(double *, int, int *);

int     Limit_Value_i(int *, int, int, char *);
int     Limit_Value_l(long *, long, long, char *);
int     Limit_Value_f(float *, double, double, char *);
int     Limit_Value_d(double *, double, double, char *);

int     Out_Of_Range_i(int, int, int, char *);
int     Out_Of_Range_l(long, long, long, char *);
int     Out_Of_Range_f(double, double, double, char *);
int     Out_Of_Range_d(double, double, double, char *);

int     Move_d(double *, int, double *, int, int);	/* v2 = v1  */
int     Move_f(float *, int, float *, int, int);
int     Move_i(int *, int, int *, int, int);
int     Movexd(double *, int, double *, int, int);	/* v2 = v1   but *v2
							 * must not = *v1  */
int     Movexf(float *, int, float *, int, int);
int     Movexi(int *, int, int *, int, int);

int     Add_d(double *, int, double *, int, double *, int, int);	/* v3 = v1 + v2                      */
int     Add_f(float *, int, float *, int, float *, int, int);
int     Add_i(int *, int, int *, int, int *, int, int);

int     Sub_d(double *, int, double *, int, double *, int, int);	/* v3 = v1 - v2  */
int     Sub_f(float *, int, float *, int, float *, int, int);
int     Sub_i(int *, int, int *, int, int *, int, int);

int     Piv_d( double, double *, int, double *, int, double *, int, int );		/* v3 = scal.v1 + v2                 */
int     Piv_f( double, float *, int, float *, int, float *, int, int );
int     Piv_i( int, int *, int, int *, int, int *, int, int );

int     Scal_d( double, double *, int, double *, int, int );		/* v2 = scal.v1                      */
int     Scal_f( double, float *, int, float *, int, int );
int     Scal_i( int, int *, int, int *, int, int );

double  Dot_d(double *, int, double *, int, int);	/* DotV = sum(v1.v2) */
float   Dot_f(float *, int, float *, int, int);
int     Dot_i(int *, int, int *, int, int);

int     Crosp_i();		/* v3 = v1 x v2                      */
int     Crosp_f();
int     Crosp_d();

float   Norm_f(float *, int);
double  Norm_d(double *, int);

float   Mag_f(float *, int);
double  Mag_d(double *, int);

/* Matrix routines */

int     Mul_i( int, int, int, int *, int *, int * );		/* C = A * B                          */
int     Mul_d( int, int, int, double *, double *, double * );

int     Transpose_i( int, int, int *, int * );
int     Transpose_d( int, int, double *, double * );

int     Homog_Trans(double [4][4], double *, double *);	/* Homogeneous
							 * transformation  */

int     Gauss( double[], double[], double[], int );		/* solves x  for Ax = b                */
int     GausX(double *, double *, double *, int, int);
double  Gauss_Cond(double *, double *, double *, int, int);	/* as above but also
								 * returns condition No */
void    Print_Matrix_d( double *, int, int );

void    SetIntArray(int *, int, int, ...);
void    Set_Int_Array(int *, int, int, ...);
void    SetDoubleArray(double *, int, double, ...);
void    Set_Double_Array(double *, int, double, ...);
void    Copy_Int_To_Double(int *, int, double *, int, int);
int	*Allocate_IArray( int );
float	*Allocate_FArray( int );
long	*Allocate_LArray( int );
double  *Allocate_DArray( int );
char	**Allocate_Matrix( int, int, int );
void	Free_Matrix( char ** );

#endif /* !__vip_f */

