/*******************************************************************************
*
* University of Western Australia
* Department of Computer Science
* Copyright (c) University of Western Australia
*
* SYSTEM :              VIP
* RELEASE:		3
* SUBSYSTEM:            INCLUDE
* MODULE:		iff.h	 Image File Format for Alvey Vision Consortium 2
   From 2nd. draft 12.9.84 by Andrew Blake
* REVISION:             3.1
* AUTHOR:		CB/AB               
* CREATION DATE:        15 April 1985
* REVISION DATE:	7/14/92        
*
********************************************************************************
*
* REVISION LOG
*
* REVISION:             3.1
* REVISION DATE:	10 July 1992
* COMMENT:		ANSIfied and SCCS'd
* BY:			CFF
*
* @(#)iff.h	3.1 7/14/92
*
*******************************************************************************/

typedef struct struct_IFFHDR {
        short header_length;	/* length of header in words */
        short image_type;		/* BYTE, WORD, or BOOLEAN     */
        short height;		/* image height in pixels */
        short width;		/* image width  in pixels */
        short signed;		/* 1 => signed data, 0=> unsigned */
        short fov_height;		/* field of view height (mrad) */
        short fov_width;		/* field of view width  (mrad) */
        short stereo;		/* 1 => stereo pair, 0 => mono */
        short baseline;		/* optical centres separation, (mm) */
        short vergence;		/* vergence angle (mrad) */
        short gaze;			/* gaze angle (mrad) */
        short source_id;		/* i.d. of camera etc. */
        short processed;		/* 1 => processed since generation */
        char  date[8];		/* date of generation dd/mm/yy */
        char  time[8];		/* time of generation hh:mm:ss */
        short stop;			/* lens stop (f no. x 100) */
        short focus;		/* lens focal length (mm) */
				/* next two added by Chris Brown */
        short magic;		/* magic no. to detect byte reversal */
        char title[80];		/* null-terminated text title */
  } IFFHDR;

typedef struct struct_EDGEL_LIST {
   float data[4];
   struct struct_EDGEL_LIST *next;
 } EDGEL_LIST;

typedef struct struct_LINK
 {
     unsigned short to;
     struct struct_LINK *nextl;
 } LINK;



#define IFF_MAGIC 0x8516	/* magic number */
#define IFF_AMIGC 0x1685	/* byte swapped version */
#define UNKNOWN 32767		/* flags unknown entries */
#define BYTE 0			/* image types */
#define WORD 1
#define BOOLEAN 2
#define EDGE 3
#define OTHER 1000
#define EDGEL 999  /* as output by Sheffield style canny op */
#define EDGE_HOR 0200		/* Edge direction codes */
#define EDGE_VER 0100

/* Site identifiers    -     these go in the source_id field.
   "Thousands"  digit  identifies  the site.   Zero indicates
   universal - i.e., image generators which are common across
   sites. Bottom three digits are site-specific.    Nobody is
   expected to take any notice of these.
*/

#define SITE_SHEFF	1000	/* Sheffield AI Vision Unit */
#define SITE_EDCS	2000	/* Edinburgh Comp. Sci. (Blake) */
#define SITE_EDAI	3000	/* Edinburgh AI Dept */
#define SITE_QMC	4000	/* Queen Mary College (Buxton) */
#define WINSOM	100


