/**********************************************************************
*              region.c                                               *
*                                                                     *
*  Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info.   *
*                                                                     *
*  This module contains code to handle TIS region functions.          *
*                                                                      *
*  280495 -HT- Select(), DrawThatBox(), DestroyThatBox() and            *
*              SetTool() are working. Great work is done here.          *
*  290495 -HT- GetClipboard().                                          *
*  030595 -HT- CropClipToImage().                                       *
*  049595 -HT- A lot of work with Paste function is done. h, of course *
*              we could say it works, but... there is a lot to do.      *
*  060595 -HT- Paste() works?                                           *
*  070595 -HT- DestroyPasteBox() works? No it doesn't.                  *
*  080595 -HT- Paste() and DestroyPasteBox() seems to work. Huh.        *
*  160595 -HT- Makefile support.                                        *
************************************************************************/

#include <math.h>
#include <X11/Xlib.h>
#include "image.h"
#include "externs.h"

Select( sx1, sy1 )
short sx1, sy1;
{
  short sx2, sy2;

  if( ThatBox.in ) DestroyThatBox();

  if( GetArea( &sx1, &sy1, &sx2, &sy2 ) ) {
    printf("Illegal starting point.\n");
    return;
    }
  printf("Selected: %d,%d-%d,%d\n", sx1, sy1, sx2, sy2 );

  DrawThatBox( sx1, sy1, sx2-sx1, sy2-sy1 );
  ThatBox.whole = False;   /* NOTIFY ME! I'M QUITE A IMPORTANT LITTLE THING */
}

/* bx and by are relative to Image */
DrawThatBox( bx, by, width, height )
short bx, by, width, height;
{
  XSetForeground( theDisplay, theGC, theBlackPixel );
  XDrawRectangle( theDisplay, theWindow, theGC, bx+offs_X[Cur_Image], 
                  by+offs_Y[Cur_Image]+MARGIN, width, height );

  ThatBox.in = True;
  ThatBox.x = bx+offs_X[Cur_Image];
  ThatBox.y = by+offs_Y[Cur_Image]+MARGIN;
  ThatBox.width = width;
  ThatBox.height = height;
}

DestroyThatBox()
{
  if( ThatBox.in )
    {
    XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
              ThatBox.x-offs_X[Cur_Image], ThatBox.y-offs_Y[Cur_Image]-MARGIN,
              ThatBox.x, ThatBox.y, ThatBox.width, 1 );
    XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
              ThatBox.x-offs_X[Cur_Image], ThatBox.y-offs_Y[Cur_Image]-MARGIN,
              ThatBox.x, ThatBox.y, 1, ThatBox.height );
    XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
              ThatBox.x-offs_X[Cur_Image]+ThatBox.width, 
              ThatBox.y-offs_Y[Cur_Image]-MARGIN,
              ThatBox.x+ThatBox.width, ThatBox.y, 1, ThatBox.height );
    XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
              ThatBox.x-offs_X[Cur_Image], 
              ThatBox.y-offs_Y[Cur_Image]-MARGIN+ThatBox.height,
              ThatBox.x, ThatBox.y+ThatBox.height, ThatBox.width+1, 1 );
    ThatBox.in = False;
    }
}

/* SetTool function is used to set curren tool number to 1, 2 or 3. */
SetTool( tnro )
{
  tool = tnro;

  if( tool==1 ) OperateRadio( 1, 0 );
  if( tool==2 ) OperateRadio( 1, 1 );
  if( tool==3 ) OperateRadio( 1, 2 );
}

GetClipboard( save, clear )
char save, clear;
{
  int cx, cy;

  for( cy=0; cy<Clip_Image.height; cy++ )     /* Check if Clip_Image exists */
    free( Clip_Image.data.map_lines[cy] );
  free( Clip_Image.data.map_lines );
  free( Clip_Image.Colour_Map );
  Clip_Image.width = 0;

  if( save )
    Make_Empty_Image( &Clip_Image, ThatBox.width+1, ThatBox.height+1 );

  DestroyThatBox();
  SetTool( old_tool );

  for( cy=0; cy<ThatBox.height+1; cy++ )
    for( cx=0; cx<ThatBox.width+1; cx++ )
      {
      if( save )
        Clip_Image.data.map_lines[cy][cx] =
          One_Image[Cur_Image].data.map_lines[cy-offs_Y[Cur_Image]-MARGIN+ThatBox.y]
                                           [cx-offs_X[Cur_Image]+ThatBox.x];
      if( clear )
        {
        XSetForeground( theDisplay, theGC, theWhitePixel );
        XDrawPoint( theDisplay, theWindow, theGC, ThatBox.x+cx, ThatBox.y+cy );
        One_Image[Cur_Image].data.map_lines[cy-offs_Y[Cur_Image]-MARGIN+ThatBox.y]
                                  [cx-offs_X[Cur_Image]+ThatBox.x] = 0;
        }
      }
  if( clear )
    MakeImage( Cur_Image );
}

CropClipToImage()
{
  int y;

  if( ThatBox.whole )
    {
    printf("Cannot crop whole image to itself\n");
    return;
    }

  if( ThatBox.in )
    GetClipboard( True, False );
  else if( !Clip_Image.width )
    {
    printf("Crop what?!\n");
    return;
    }

  if( ThatBox.in )
    DestroyThatBox();

  CopyImageXToImageY( &Clip_Image, &One_Image[Cur_Image], Cur_Image );

  printf("Image succesfully recropped\n");
}

/* msx and msy are relative to window.                                */
/* Note! that the following code is something very complex and        */
/* everything seems to have an effect to everywhere. So, be carefull! */
Paste( msx, msy )
int msx, msy;
{
  int pbox_x, pbox_y, pbox_w, pbox_h, wx, wy, handle_X, handle_Y;

  if( ThatBox.in )
    GetClipboard( True, False );
  else if( !Clip_Image.width )
    {
    printf("Paste what?!\n");
    SetTool( old_tool );
    return;
    }

  if( ThatBox.in )
    DestroyThatBox();

  switch( handle )
    {
    case 0:
      handle_X = 0;
      handle_Y = 0;
      break;
    case 1:
      handle_X = Clip_Image.width -1;
      handle_Y = 0;
      break;
    case 2:
      handle_X = (int)((float)Clip_Image.width/2.0);
      handle_Y = (int)((float)Clip_Image.height/2.0);
      break;
    case 3:
      handle_X = 0;
      handle_Y = Clip_Image.height -1;
      break;
    case 4:
      handle_X = Clip_Image.width -1;
      handle_Y = Clip_Image.height -1;
      break;
    default:
      printf("Illegal Handle number\n");
      break;
    }

  if( PasteBox.in )
    DestroyPasteBox();

  GetWindowSize( &wx, &wy );

  if( msx<offs_X[Cur_Image] ) msx=offs_X[Cur_Image];
  if( msx<0 ) msx=0;
  if( msy<offs_Y[Cur_Image]+MARGIN ) msy=offs_Y[Cur_Image]+MARGIN;
  if( msy<0 ) msy=0;
  if( msx>offs_X[Cur_Image]+One_Image[Cur_Image].width -1)
    msx=offs_X[Cur_Image]+One_Image[Cur_Image].width -1;
  if( msx>wx ) msx=wx;
  if( msy>offs_Y[Cur_Image]+One_Image[Cur_Image].height+MARGIN -1)
    msy=offs_Y[Cur_Image]+One_Image[Cur_Image].height+MARGIN -1;
  if( msy>wy ) msy=wy;
  
  pbox_x = msx - handle_X;
  pbox_y = msy - handle_Y;
  pbox_w = Clip_Image.width-1;
  pbox_h = Clip_Image.height-1;

  PasteBox.x = msx - handle_X;
  PasteBox.y = msy - handle_Y;
  PasteBox.width = Clip_Image.width-1;
  PasteBox.height = Clip_Image.height-1;
  PasteBox.in = True;

  if( PasteBox.x < offs_X[Cur_Image] ) {
    pbox_x = offs_X[Cur_Image];
    pbox_w-= offs_X[Cur_Image]-PasteBox.x; }
  else if( PasteBox.x < 0 ) {
    pbox_x = 0;
    pbox_w-= -PasteBox.x; }
  if( PasteBox.y < offs_Y[Cur_Image]+MARGIN ) {
    pbox_y = offs_Y[Cur_Image]+MARGIN;
    pbox_h-= offs_Y[Cur_Image]+MARGIN-PasteBox.y; }
  if( PasteBox.y < MARGIN && offs_Y[Cur_Image] < 0 ) {
    pbox_y = MARGIN;
    pbox_h = Clip_Image.height-1-(MARGIN-PasteBox.y); }
  if( PasteBox.x+PasteBox.width > One_Image[Cur_Image].width + 
           offs_X[Cur_Image] -1 )
      pbox_w = One_Image[Cur_Image].width + offs_X[Cur_Image] - PasteBox.x -1;
  else if( PasteBox.x+PasteBox.width > wx )
      pbox_w = wx - PasteBox.x;
  if( PasteBox.y+PasteBox.height > One_Image[Cur_Image].height + offs_Y[Cur_Image] + MARGIN -1 )
    pbox_h = One_Image[Cur_Image].height + offs_Y[Cur_Image] + MARGIN - PasteBox.y -1;
  else if( PasteBox.y+PasteBox.height > wy )
    pbox_h = wy - PasteBox.y;

  XSetForeground( theDisplay, theGC, theBlackPixel );
  printf("Drawerraraw %d,%d - %d,%d\n", pbox_x, pbox_y, pbox_x+pbox_w, pbox_y+pbox_h );
  if( PasteBox.x == pbox_x )
    XDrawLine( theDisplay, theWindow, theGC, pbox_x, pbox_y, pbox_x, pbox_y+pbox_h );
  if( PasteBox.y == pbox_y )
    XDrawLine( theDisplay, theWindow, theGC, pbox_x, pbox_y, pbox_x+pbox_w, pbox_y );
  if( pbox_x+pbox_w>=offs_X[Cur_Image] && pbox_x+pbox_w>=0
      && pbox_x+pbox_w<offs_X[Cur_Image]+One_Image[Cur_Image].width-1
      && pbox_x+pbox_w<wx )
    XDrawLine( theDisplay, theWindow, theGC, pbox_x+pbox_w, pbox_y, pbox_x+pbox_w, pbox_y+pbox_h );
  if( pbox_y+pbox_h>=offs_Y[Cur_Image]+MARGIN && pbox_y+pbox_h>=MARGIN
      && pbox_y+pbox_h<offs_Y[Cur_Image]+MARGIN+One_Image[Cur_Image].height-1
      && pbox_y+pbox_h<wy-MARGIN )
    XDrawLine( theDisplay, theWindow, theGC, pbox_x, pbox_y+pbox_h, pbox_x+pbox_w, pbox_y+pbox_h );
}

/* This is something really complex too.. */
DestroyPasteBox()
{
  int pbox_x, pbox_y, pbox_w, pbox_h, wx, wy;

  if( PasteBox.in )
    {
    pbox_x = PasteBox.x;
    pbox_y = PasteBox.y;
    pbox_w = PasteBox.width;
    pbox_h = PasteBox.height;

    GetWindowSize( &wx, &wy );

    if( PasteBox.x < offs_X[Cur_Image] ) {
      pbox_x = offs_X[Cur_Image];
      pbox_w-= offs_X[Cur_Image]-PasteBox.x; }
    else if( PasteBox.x < 0 ) {
      pbox_x = 0;
      pbox_w-= -PasteBox.x; }
    if( PasteBox.y < offs_Y[Cur_Image]+MARGIN ) {
      pbox_y = offs_Y[Cur_Image]+MARGIN;
      pbox_h-= offs_Y[Cur_Image]+MARGIN-PasteBox.y; }
    if( PasteBox.y < MARGIN && offs_Y[Cur_Image] < 0 ) {
      pbox_y = MARGIN;
      pbox_h = Clip_Image.height-1-(MARGIN-PasteBox.y); }
    if( PasteBox.x+PasteBox.width > One_Image[Cur_Image].width + offs_X[Cur_Image] -1 )
      pbox_w = One_Image[Cur_Image].width + offs_X[Cur_Image] - PasteBox.x -1;
    else if( PasteBox.x+PasteBox.width > wx )
      pbox_w = wx - PasteBox.x;
    if( PasteBox.y+PasteBox.height > One_Image[Cur_Image].height + offs_Y[Cur_Image] + MARGIN -1 )
      pbox_h = One_Image[Cur_Image].height + offs_Y[Cur_Image] + MARGIN - PasteBox.y -1;
    else if( PasteBox.y+PasteBox.height > wy )
      pbox_h = wy - PasteBox.y;

    printf("DestroyPasteBox: %d,%d - %d,%d\n", pbox_x, pbox_y,
           pbox_x+pbox_w, pbox_y+pbox_h );
    XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
              pbox_x-offs_X[Cur_Image], pbox_y-offs_Y[Cur_Image]-MARGIN,
              pbox_x, pbox_y, pbox_w+1, 1 );
    XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
              pbox_x-offs_X[Cur_Image], pbox_y-offs_Y[Cur_Image]-MARGIN,
              pbox_x, pbox_y, 1, pbox_h+1 );
    if( pbox_x+pbox_w>=offs_X[Cur_Image] && pbox_x+pbox_w>=0
        && pbox_x+pbox_w<offs_X[Cur_Image]+One_Image[Cur_Image].width-1
        && pbox_x+pbox_w<wx )
      XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
                pbox_x-offs_X[Cur_Image]+pbox_w, 
                pbox_y-offs_Y[Cur_Image]-MARGIN,
                pbox_x+pbox_w, pbox_y, 1, pbox_h+1 );
    if( pbox_y+pbox_h>=offs_Y[Cur_Image]+MARGIN && pbox_y+pbox_h>=MARGIN
        && pbox_y+pbox_h<offs_Y[Cur_Image]+MARGIN+One_Image[Cur_Image].height-1
        && pbox_y+pbox_h<wy/*-MARGIN*/ )
      XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
                pbox_x-offs_X[Cur_Image], 
                pbox_y-offs_Y[Cur_Image]-MARGIN+pbox_h,
                pbox_x, pbox_y+pbox_h, pbox_w+1, 1 );
    PasteBox.in = False;
    }
}

/* This function does the actual Paste effect. */
PasteTheFinalFight()
{
  int cx, cy, wx, wy;

  GetWindowSize( &wx, &wy );

  printf("PasteTheFinalFight\n");
  if( PasteBox.in )
    DestroyPasteBox();

  for( cy=0; cy<Clip_Image.height; cy++ )
    for( cx=0; cx<Clip_Image.width; cx++ )
      if( PasteBox.x+cx >= offs_X[Cur_Image]
          && PasteBox.x+cx < offs_X[Cur_Image]+One_Image[Cur_Image].width
          && PasteBox.y-MARGIN+cy >= offs_Y[Cur_Image]
          && PasteBox.y-MARGIN+cy < offs_Y[Cur_Image]+One_Image[Cur_Image].height )
        {
        if( One_Image[Cur_Image].Colour_Map_Size>0 )
          XPutPixel(image_xi[Cur_Image],PasteBox.x-offs_X[Cur_Image]+cx,PasteBox.y-MARGIN-offs_Y[Cur_Image]+cy,colormap[Clip_Image.data.map_lines[cy][cx]]);
        /*else
          XPutPixel(image_xi[3],x,y,colormap[
            (int)(One_Image[3].data.rgb_lines[y].red[x]/42.5)*36
            +(int)(One_Image[3].data.rgb_lines[y].green[x]/42.5)*6
            +(int)(One_Image[3].data.rgb_lines[y].blue[x]/42.5)]);*/
        One_Image[Cur_Image].data.map_lines[PasteBox.y-MARGIN-offs_Y[Cur_Image]+cy]
                                           [PasteBox.x-offs_X[Cur_Image]+cx]
                                  =Clip_Image.data.map_lines[cy][cx];
        if( PasteBox.x+cx>=0 && PasteBox.x+cx<wx && PasteBox.y+cy>=MARGIN && PasteBox.y+cy<wy )
          {
          if( Clip_Image.data.map_lines[cy][cx]==1 )
            XSetForeground( theDisplay, theGC, theBlackPixel );
          else
            XSetForeground( theDisplay, theGC, theWhitePixel );
          XDrawPoint( theDisplay, theWindow, theGC, PasteBox.x+cx,
                      PasteBox.y+cy );
          }
        }
}
