/********************************************************************
*                menue.c                                            *
*                                                                   *
*  Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info. *
*                                                                   *
*  This module contains code to do what we have to do when          *
*  menu is selected.                                               *
*                                                                 *
*  250395 -HT- Very first version.                                *
*  270395 -HT- Load() and Save() are now in own load_save.c file. *
*  290395 -HT- Master image cannot be loaded, so we call Mesg()   *
*  030495 -HT- Save, About and Quit are now also working here.    *
*  070495 -HT- We are having a lot of new code here: Tools,       *
*              Images and Modes menus are now working, so and so. *
*              OperateRadio() function is now in use.             *
*  120495 -HT- Filled rect. add.                                  *
*  160495 -HT- Copying and swapping between images add.           *
*  170495 -HT- Call to ImageInfo().                               *
*  200495 -HT- Call to SetImageSize().                            *
*  220495 -HT- Call to SetImageOffset().                          *
*  250495 -HT- Call to AutoSetImageSize().                        *
*  260495 -HT- Offset Origo and Auto Resize Window works.         *
*  280495 -HT- Select, Select All and Unselect works.             *
*  290495 -HT- Cut, Copy and Clear are working.                   *
*  030595 -HT- CropClipToImage() add.                             *
*  040595 -HT- Paste add.                                         *
*  060595 -HT- Change Handle add.                                 *
*  090595 -HT- Flip, Rotate and Negative add.                     *
*  160595 -HT- Makefile support.                                  *
******************************************************************/

#include <X11/Xlib.h>
#include "image.h"
#include "externs.h"

HandleMenuEvent( m1, m2 )
unsigned char m1, m2;
{
  /*char file_name[30]={"file"};*/
  short wwidth, wheight;
  unsigned char result;

  switch( m1 )
    {
    case 0: /***** Picture: *****/
      if( tool==10 || tool==11 ) SetTool( old_tool );
      if( ThatBox.in ) DestroyThatBox();
      if( PasteBox.in ) DestroyPasteBox();
      switch( m2 )
        {
        case 0:
          /**  Load  **/
          if( Cur_Image!=3 )
            Load_Image( Cur_Image );
          else
            {
            result = Mesg("Cannot load Master image!", "Is it clear?", "OK" );
            if( result&2 )
              {
              Refresh( Cur_Image );
              DrawPanel();
              }
            }
          printf("Load\n");
          break;
        case 1:
          /**  Save **/
          if( Cur_Image==3 )
            Save_Image( 3 );
          else
            {
            result = Mesg("Only Master image can be", "saved!  Is it Clear?", "OK" );
            if( result&2 )
              {
              Refresh( Cur_Image );
              DrawPanel();
              }
            }
          printf("Save\n");
          break;
        case 2:
          /** About **/
          printf("About\n");
          result = Mesg("The Image Studio  v0.5", "by Hessu", "Wow!" );
          if( result&2 )
            {
            Refresh( Cur_Image );
            DrawPanel();
            }
          break;
        case 3:
          /** Quit **/
          printf("Quit\n");
          result = Question("","Are you sure you want to quit?",
                            "","Yes, I am.","No, I'm not.");
          if( !(result&1) )
            Quit("Thanks for using TIS");
          if( result&2 )
            {
            Refresh( Cur_Image );
            DrawPanel();
            }
          break;
        }
      break;
    case 1:  /***** Tools: *****/
      if( ThatBox.in ) DestroyThatBox();
      if( PasteBox.in ) DestroyPasteBox();
      switch( m2 )
        {
        case 0:
          /* Pen */
          tool=1;
          break;
        case 1:
          /* Rectangle */
          tool=2;
          break;
        case 2:
          /* Filled Rectangle */
          tool=3;
          break;
        }
      break;
    case 2:  /***** Images: *****/
      if( tool==10 || tool==11 ) SetTool( old_tool );
      if( ThatBox.in ) DestroyThatBox();
      if( PasteBox.in ) DestroyPasteBox();
      switch( m2 )
        {
        case 0:
          /* Master Image */
          Cur_Image=3;
          OperateRadio( m1, m2 );
          Refresh( Cur_Image );
          break;
        case 1:
          /* Primary Image */
          Cur_Image=1;
          OperateRadio( m1, m2 );
          Refresh( Cur_Image );
          break;
        case 2:
          /* Secondary Image */
          Cur_Image=2;
          OperateRadio( m1, m2 );
          Refresh( Cur_Image );
          break;
        }
      break;
    case 3: /***** Modes: *****/
      switch( m2 )
        {
        case 0:
          /* Unite */
          mode=1;
          break;
        case 1:
          /* Paint */
          mode=2;
          break;
        case 3:
          /* Area (20x20) */
          style=1;
          OperateRadio( m1, m2 );
          printf("Style set to 1  Area (20x20)\n");
          break;
        case 4:
          /* Area (5x5) */
          style=2;
          OperateRadio( m1, m2 );
          printf("Style set to 2  Area (5x5)\n");
          break;
        case 5:
          /* Grid (10x10|2) */
          style=3;
          OperateRadio( m1, m2 );
          printf("Style set to 3  Grid (10x10|2)\n");
          break;
        case 6:
          /* Grid (6x6|3) */
          style=4;
          OperateRadio( m1, m2 );
          printf("Style set to 4  Grid (6x6|3)\n");
          break;
        case 7:
          /* Single dots */
          style=5;
          OperateRadio( m1, m2 );
          printf("Style set to 5  Single dots\n");
          break;
        }
      break;
    case 4: /***** Region: *****/
      switch( m2 )
        {
        case 0:   /* Select */
          if( tool!=10 && tool!=11 ) old_tool = tool;
          tool = 10;
          break;
        case 1:  /* Select all */
          OperateRadio( 4, 0 );
          if( tool!=10 ) old_tool = tool;
          tool = 10;
          if( ThatBox.in ) DestroyThatBox();
          printf("Selected: %d,%d-%d,%d\n", 0, 0, One_Image[Cur_Image].width-1, One_Image[Cur_Image].height-1 );
          DrawThatBox( 0, 0, One_Image[Cur_Image].width-1, One_Image[Cur_Image].height-1 );
          ThatBox.whole = True;   /* NOTIFY ME! I'M QUITE A IMPORTANT */
          break;
        case 2:  /* Unselect */
          if( tool==10) SetTool( old_tool );
          if( ThatBox.in ) DestroyThatBox();
          break;
        case 3:  /* Cut */
          if( tool==10 && (ThatBox.in) )
            GetClipboard( True, True );
          break;
        case 4:  /* Copy */
          if( tool==10 && (ThatBox.in) )
            GetClipboard( True, False );
          break;
        case 5:  /* Clear */
          if( tool==10 && (ThatBox.in) )
            GetClipboard( False, True );
          break;
        case 6:  /* Paste */
          if( tool!=11 && tool!=10 ) old_tool = tool;
          tool = 11;
          if( ThatBox.in ) DestroyThatBox();
          break;
        case 7:  /* Crop to Image */
          CropClipToImage();
          if( tool==10 || tool==11 ) SetTool( old_tool );
          break;
        case 8:  /* Change Handle */
          handle++;
          if( handle>4 ) handle=0;
          switch( handle )
            {
            case 0: printf("Handle set to TOP_LEFT\n"); break;
            case 1: printf("Handle set to TOP_RIGHT\n"); break;
            case 2: printf("Handle set to CENTER\n"); break;
            case 3: printf("Handle set to BOTTOM_LEFT\n"); break;
            case 4: printf("Handle set to BOTTOM_RIGHT\n"); break;
            }
          break;
        }
      break;
    case 5: /***** Effects: *****/
      switch( m2 )
        {
        case 0:   /* Flip Horiz */
          Effect( 0 );
          break;
        case 1:   /* Flip Vert */
          Effect( 1 );
          break;
        case 2:   /* Rotate Right */
          Effect( 2 );
          break;
        case 3:   /* Rotate Left */
          Effect( 3 );
          break;
        case 4:   /* Negative */
          Effect( 4 );
          break;
        }
      break;
    case 6: /***** Other: *****/
      if( (tool==10 || tool==11) && m2<14 ) SetTool( old_tool );
      if( ThatBox.in && m2<14 ) DestroyThatBox();
      if( PasteBox.in && m2<14 ) DestroyPasteBox();
      switch( m2 )
        {
        case 0:   /* Primary->Master */
          CopyImageXToImageY( &One_Image[1], &One_Image[3], 3 );
          break;
        case 1:   /* Secondary->Master */
          CopyImageXToImageY( &One_Image[2], &One_Image[3], 3 );
          break;
        case 2:   /* Master->Primary */
          CopyImageXToImageY( &One_Image[3], &One_Image[1], 1 );
          break;
        case 4:   /* Master<->Primary */
          SwapImages( 3, 1 );
          break;
        case 5:   /* Master<->Secondary */
          SwapImages( 3, 2 );
          break;
        case 6:   /* Primary<->Secondary */
          SwapImages( 1, 2 );
          break;
        case 8:   /* Image Info */
          ShowImageInfo();
          break;
        case 9:   /* Set Size */
          SetImageSize();
          break;
        case 10:  /* Set offset */
          SetImageOffset();
          break;
        case 11:  /* Auto Set */
          AutoSetImageSize();
          break;
        case 12:  /* Offset Origo */
          offs_X[Cur_Image] = 0;
          offs_Y[Cur_Image] = 0;
          Refresh( Cur_Image );
          break;
        case 14:  /* Auto Resize Window */
          wwidth = offs_X[Cur_Image] + One_Image[Cur_Image].width;
          wheight = offs_Y[Cur_Image] + One_Image[Cur_Image].height;
          if( wwidth<WIDTH ) wwidth = WIDTH;
          if( wheight<HEIGHT ) wheight = HEIGHT;
          XResizeWindow(theDisplay, theWindow, wwidth, wheight+MARGIN );
          break;          
        case 15:  /* Refresh Window */
          Super_Refresh( Cur_Image );
          break;
        }
      break;
    }
}
