/*********************************************************************
*                 lmesg.c                                            *
*                                                                    *
*  Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info.  *
*                                                                    *
*  This module contains code to view large text messages             *
*  in the window.                                                   *
*                                                                  *
*  290395 -HT- Seems to work.                                     *
*  190495 -HT- Mesg() modified to L_Mesg().                      *
*  160595 -HT- Makefile support.                                *
***************************************************************/

#include <math.h>
#include <X11/Xlib.h>
#include "image.h"
#include "externs.h"

L_Mesg( msg1, msg2, msg3, msg4, msg5, msg6, msg7, msg8 )
char *msg1, *msg2, *msg3, *msg4, *msg5, *msg6, *msg7, *msg8;
{
  XWindowAttributes theAttributes;
  short offx, offy;
  char fresh=0;

  XGetWindowAttributes( theDisplay, theWindow, &theAttributes );
  if( theAttributes.width<310 || theAttributes.height<210 )
    return(1);

  offx = (int)((float)theAttributes.width/2.0)-150;
  offy = (int)((float)theAttributes.height/2.0)-100;

  storage_block_xi = XGetImage(theDisplay, theWindow, offx, offy,
                               300+1, 200+1, 255, ZPixmap);

  XClearArea( theDisplay, theWindow, offx, offy, 300, 200, False );
  XFlush(theDisplay);

  Draw_L_Message( msg1, msg2, msg3, msg4, msg5, msg6, msg7, msg8, offx, offy );

  while(1)
    {
    XNextEvent( theDisplay, &theEvent );

    switch( theEvent.type )
      {
      case Expose:
        Draw_L_Message( msg1, msg2, msg3, msg4, msg5, msg6, msg7, msg8, offx, offy );
        fresh=2;
        break;
      case ConfigureNotify:
        XGetWindowAttributes( theDisplay, theWindow, &theAttributes );
        if( theAttributes.width<310 || theAttributes.height<210 )
          {
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 300+1, 200+1 );
          return( 1|fresh );
          }
        break;
      case KeyPress:
        if( theEvent.xkey.keycode==36 )
          {
          printf("OK\n");
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 300+1, 200+1 );
          return( 0|fresh );
          }
        break;
      case ButtonPress:
        if( theEvent.xbutton.x>offx+20 && theEvent.xbutton.x<offx+280 &&
            theEvent.xbutton.y>offy+165 && theEvent.xbutton.y<offy+185 )
          {
          printf("OK\n");
          XPutImage(theDisplay, theWindow, theGC, storage_block_xi,
                    0, 0, offx, offy, 300+1, 200+1 );
          return( 0|fresh );
          }
        break;
      }
    }
}

Draw_L_Message( msg1, msg2, msg3, msg4, msg5, msg6, msg7, msg8, offx, offy )
char *msg1, *msg2, *msg3, *msg4, *msg5, *msg6, *msg7, *msg8;
short offx, offy;
{
  short btx;

  XSetForeground( theDisplay, theGC, theBlackPixel );
  XDrawRectangle( theDisplay, theWindow, theGC, offx, offy, 300, 200 );
  XDrawRectangle( theDisplay, theWindow, theGC, offx+20, offy+165, 260, 20 );
  XDrawString( theDisplay, theWindow, theGC, offx+20, offy+20, msg1, strlen(msg1) );  
  XDrawString( theDisplay, theWindow, theGC, offx+20, offy+40, msg2, strlen(msg2) );
  XDrawString( theDisplay, theWindow, theGC, offx+20, offy+60, msg3, strlen(msg3) );
  XDrawString( theDisplay, theWindow, theGC, offx+20, offy+80, msg4, strlen(msg4) );
  XDrawString( theDisplay, theWindow, theGC, offx+20, offy+100, msg5, strlen(msg5) );
  XDrawString( theDisplay, theWindow, theGC, offx+20, offy+120, msg6, strlen(msg6) );
  XDrawString( theDisplay, theWindow, theGC, offx+20, offy+140, msg7, strlen(msg7) );
  btx = offx+150-(int)((float)strlen(msg8)/2.0)*7;
  XDrawString( theDisplay, theWindow, theGC, btx, offy+180, msg8, strlen(msg8) );
  XFlush(theDisplay);
}

