#import "p6.h"

@implementation p6
- resizeGenerator
{
  latticesize.height = 8.0/3.0 * bounds.size.height;
  latticesize.width = bounds.size.width * 2.0;
  upx = bounds.size.width;
  upy = 2.0 * bounds.size.height;
  overx = latticesize.width;
  return self;
}

- clip: (NXCoord) x: (NXCoord) y 
{ 
  PSnewpath();
  PSmoveto(x,y);
  PSrlineto(bounds.size.width,0);
  PSrlineto(0,latticesize.height/4.0);
  PSrlineto(-[self equi: latticesize.height/4.0],latticesize.height/8.0);
  PSclosepath();
  PSclip();
  return self;
}

- makeLatticeUnitAt: (NXPoint *) point fromImage: srcimg 
{
  id imgrep;
  int i;
  NXPoint pt;
  
  pt.x = - point->x ;
  pt.y = - point->y ;
  imgrep = [srcimg bestRepresentation];
  for(i=0;i<6;i++){
    PSgsave();
    PSrotate(60*i);
    [self clip:0.0:0.0];
    [imgrep drawAt: &pt];
    PSgrestore();
  }
  return self;
}
- sizeKludge: (float *) x : (float *) y
{
  float hyp;

  *y = [self equi: *x];
  return self;
}
@end
