/*
 * marble shader - simulates marble using noise & turbulence
 */

#include <math.h>
#include <stdio.h>

#include <sipp.h>
#include <noise.h>
#include <shaders.h>


extern bool noise_ready;

void
bozo_shader(nx, ny, nz, u, v, w, view_vec, lights, bd, color)
    double  nx, ny, nz, u, v, w;
    Vector  view_vec;
    Lightsource *lights;
    Bozo_desc *bd;
    Color *color;
{
    Vector     tmp;
    Surf_desc  surface;
    double     noiseval;
    int        i;

    if (!noise_ready) {
        noise_init();
    }

    tmp.x = u * bd->scale;
    tmp.y = v * bd->scale;
    tmp.z = w * bd->scale;
    noiseval = noise(&tmp);

    i = (noiseval + 1) * bd->no_of_cols / 2.0;
    surface.color    = bd->colors[i];
    surface.ambient  = bd->ambient;
    surface.specular = bd->specular;
    surface.c3       = bd->c3;
    basic_shader(nx, ny, nz, u, v, w, view_vec, lights, &surface, color);
}
