#include <stdio.h>
#include <math.h>

#include <sipp.h>
#include <primitives.h>



#define RESOLUTION 15


main(argc, argv)
    int    argc;
    char **argv;
{
    FILE    *fp ;
    Surf_desc surf;
    int      side;


    if (argc != 2) {
        side = 256;
    } else {
        side = atoi(argv[1]);
    }

    sipp_init();

    lightsource_push(1.0, 1.0, 1.0, 0.9);
    lightsource_push(-1.0, -1.0, 0.5, 0.4);

    surf.ambient = 0.5;
    surf.color.red = 0.6;
    surf.color.grn = 0.3;
    surf.color.blu = 0.5;
    surf.specular = 0.6;
    surf.c3 = 0.2;
    
    object_install(sipp_ellipsoid(1.0, 2.0, 3.0, RESOLUTION,
                                  &surf, basic_shader)); 

    viewpoint(10.0, 0.0, 0.0,  0.0, 0.0, 0.0,  0.0, 0.0, 1.0,  0.4);

    printf("Rendering, wait...");
    fflush(stdout);

    fp = fopen("ellipsoid.ppm", "w");
    render_image(side, side, fp);
    printf("Done.\n");
}
