/* xmenu.h: menu's met het X window systeem */

#ifndef _XMENU_H_
#define _XMENU_H_

#include <Xm/Xm.h>

/* menu's */
typedef void (*XMENUPROC)(Widget);

typedef struct XMENUITEM {
	XMENUPROC proc;
	char *label;	
} XMENUITEM;

extern Widget CreateXMenu(Widget parent, XMENUITEM *menuitems);

extern void XMenu(Widget parent, char *menutitle, XMENUITEM *menuitems);

/* invulformulieren */
#define MAXFIELDS 	20	/* maximum 20 velden 	*/
#define MAXFIELDLENGTH 100	/* velden maximaal 100 karakters breed */

typedef int XFORMTYPE;
/* invulveld types */
#define XFORMINT	1
#define XFORMFLOAT	2
#define XFORMSTRING	3

/* bij ieder invulveld hoort een formaat (dat bepaalt van welk type het
 * veld is - zie bovenstaande codes), een wijzer (waar 
 * de invoer ingevuld moet worden) en een tekst */
typedef struct XFORMFIELD {
	XFORMTYPE	type;
	char	*pvalue;
	char 	*label;
} XFORMFIELD;

extern Widget XFormCreate(Widget parent, XFORMFIELD *formfield);

extern void XForm(Widget parent, char *formtitle, XFORMFIELD *formfields);

#endif /*_XMENU_H_*/
